/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import co.com.sofka.domain.generic.AggregateRoot;
import co.com.sofka.domain.generic.AggregateRootId;
import co.com.sofka.domain.generic.DomainEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public abstract class AggregateEvent<T extends AggregateRootId>
extends AggregateRoot<T> {
    private final List<DomainEvent> changes = new LinkedList<DomainEvent>();
    private final Map<String, AtomicLong> versions = new ConcurrentHashMap<String, AtomicLong>();
    private final Set<Consumer<? super DomainEvent>> handleActions = new HashSet<Consumer<? super DomainEvent>>();

    public AggregateEvent(T entityId) {
        super(entityId);
    }

    public List<DomainEvent> getUncommittedChanges() {
        return List.copyOf(this.changes);
    }

    protected ChangeApply<AggregateEvent<T>> appendChange(DomainEvent event) {
        this.changes.add(event);
        return () -> {
            this.applyEvent(event);
            return this;
        };
    }

    protected final void registerEntityBehavior(EventBehaviors<?> eventBehaviors) {
        this.handleActions.addAll(eventBehaviors.behaviors);
    }

    protected void applyEvent(DomainEvent domainEvent) {
        this.handleActions.forEach(consumer -> {
            try {
                consumer.accept(domainEvent);
                AtomicLong map = this.versions.get(domainEvent.type);
                long version = this.nextVersion(domainEvent, map);
                domainEvent.setVersionType(version);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    private long nextVersion(DomainEvent domainEvent, AtomicLong map) {
        if (map == null) {
            this.versions.put(domainEvent.type, new AtomicLong(domainEvent.versionType()));
            return domainEvent.versionType();
        }
        return this.versions.get(domainEvent.type).incrementAndGet();
    }

    public void markChangesAsCommitted() {
        this.changes.clear();
    }

    @FunctionalInterface
    public static interface ChangeApply<T> {
        public T apply();
    }

    public static abstract class EventBehaviors<T> {
        protected T entity;
        protected Set<Consumer<? super DomainEvent>> behaviors = new HashSet<Consumer<? super DomainEvent>>();

        protected EventBehaviors(T entity) {
            this.entity = entity;
        }

        protected EventBehaviors<T> add(Consumer<? extends DomainEvent> behavior) {
            this.behaviors.add(behavior);
            return this;
        }
    }
}

