/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.business.generic;

import co.com.sofka.business.asyn.PublisherEvent;
import co.com.sofka.business.generic.UseCase;
import co.com.sofka.business.generic.UseCaseResponse;
import co.com.sofka.business.support.ResponseEvents;
import co.com.sofka.domain.generic.DomainEvent;
import java.util.Optional;
import java.util.concurrent.Flow;

public class UseCaseHandler {
    private static UseCaseHandler instance;

    private UseCaseHandler() {
    }

    public static UseCaseHandler getInstance() {
        if (instance == null) {
            instance = new UseCaseHandler();
        }
        return instance;
    }

    public <T extends UseCase.RequestValues, R extends ResponseEvents> FunctionSubscriber asyncExecutor(UseCase<T, R> useCase, T values) {
        return subscriber -> {
            try (PublisherEvent publisher = new PublisherEvent();){
                publisher.subscribe(subscriber);
                useCase.setRequest(values);
                useCase.setUseCaseCallback(publisher);
                useCase.run();
            }
        };
    }

    public <T extends UseCase.RequestValues, R extends UseCase.ResponseValues> Optional<R> syncExecutor(UseCase<T, R> useCase, T values) {
        UseCaseResponse useCaseResponse = new UseCaseResponse();
        useCase.setRequest(values);
        useCase.setUseCaseCallback(useCaseResponse);
        useCase.run();
        if (useCaseResponse.hasError()) {
            throw useCaseResponse.exception;
        }
        return Optional.ofNullable(useCaseResponse.response);
    }

    @FunctionalInterface
    public static interface FunctionSubscriber {
        public void subscribe(Flow.Subscriber<? super DomainEvent> var1);
    }
}

