/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.business.asyn;

import co.com.sofka.business.generic.UseCase;
import co.com.sofka.business.generic.UseCaseHandler;
import co.com.sofka.business.support.ResponseEvents;
import co.com.sofka.business.support.TriggeredEvent;
import co.com.sofka.domain.generic.DomainEvent;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Flow;

public abstract class ListenerEvent
implements Flow.Subscriber<DomainEvent> {
    private final Set<UseCase<? extends UseCase.RequestEvent, ? extends ResponseEvents>> useCases;
    private Flow.Subscription subscription;
    private Flow.Subscriber<DomainEvent> subscriber;

    public ListenerEvent(Set<UseCase<? extends UseCase.RequestEvent, ? extends ResponseEvents>> useCases) {
        this.useCases = useCases;
    }

    public Flow.Subscriber<DomainEvent> subscriber() {
        return Optional.ofNullable(this.subscriber).orElse(this);
    }

    public void setSubscriber(Flow.Subscriber<DomainEvent> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        this.subscription.request(1L);
    }

    @Override
    public final void onNext(DomainEvent domainEvent) {
        DomainEvent event = Objects.requireNonNull(domainEvent);
        this.useCases.forEach(useCase -> {
            UseCase useCaseCasted = useCase;
            if (this.matchDomainEvent(event).withRequestOf(useCaseCasted)) {
                UseCaseHandler.getInstance().asyncExecutor(useCaseCasted, new TriggeredEvent<DomainEvent>(event)).subscribe(this.subscriber());
            }
            this.subscription.request(1L);
        });
    }

    private ConditionalRequestUseCase matchDomainEvent(DomainEvent domainEvent) {
        return useCaseCasted -> {
            UseCase useCase = Objects.requireNonNull(useCaseCasted);
            String target = "executeUseCase";
            boolean matchWithAEvent = false;
            Method m = useCase.getClass().getDeclaredMethods()[0];
            if (target.equals(m.getName())) {
                Class<?>[] params = m.getParameterTypes();
                matchWithAEvent = this.isMatchWithAEvent(domainEvent, matchWithAEvent, m, params);
            }
            return matchWithAEvent;
        };
    }

    private boolean isMatchWithAEvent(DomainEvent domainEvent, boolean matchWithAEvent, Method m, Class<?>[] params) {
        Type returnType;
        if (params[0].getCanonicalName().equals(TriggeredEvent.class.getCanonicalName()) && (returnType = m.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            matchWithAEvent = ((Class)type.getActualTypeArguments()[0]).getCanonicalName().equals(domainEvent.getClass().getCanonicalName());
        }
        return matchWithAEvent;
    }

    @Override
    public void onError(Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }

    @FunctionalInterface
    private static interface ConditionalRequestUseCase {
        public boolean withRequestOf(UseCase<UseCase.RequestEvent, ResponseEvents> var1);
    }
}

