/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.application;

import co.com.sofka.application.ServiceBuildException;
import co.com.sofka.business.annotation.EventListener;
import co.com.sofka.business.annotation.ExtensionService;
import co.com.sofka.business.generic.ServiceBuilder;
import co.com.sofka.business.generic.UseCase;
import co.com.sofka.business.generic.UseCaseHandler;
import co.com.sofka.business.repository.DomainEventRepository;
import co.com.sofka.business.support.ResponseEvents;
import co.com.sofka.business.support.TriggeredEvent;
import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.infraestructure.asyn.SubscriberEvent;
import co.com.sofka.infraestructure.repository.EventStoreRepository;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ApplicationEventDrive {
    private static final Logger logger = Logger.getLogger(ApplicationEventDrive.class.getName());
    private final Set<UseCaseWrap> useCases;
    private final SubscriberEvent subscriberEvent;
    private final EventStoreRepository repository;
    private final String packageUseCase;

    public ApplicationEventDrive(String packageUseCase, SubscriberEvent subscriberEvent) {
        this(packageUseCase, subscriberEvent, null);
    }

    public ApplicationEventDrive(String packageUseCase, SubscriberEvent subscriberEvent, EventStoreRepository repository) {
        this.subscriberEvent = subscriberEvent;
        this.packageUseCase = packageUseCase;
        this.repository = repository;
        this.useCases = new HashSet<UseCaseWrap>();
        this.initialize();
    }

    private void initialize() {
        logger.info("---- Registered Event Listener Use Case -----");
        try (ScanResult result = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{this.packageUseCase}).scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(EventListener.class.getName());
            classInfos.parallelStream().forEach(handleClassInfo -> {
                try {
                    AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(EventListener.class.getName());
                    String type = this.getEventType(annotationInfo);
                    UseCase usecase = (UseCase)handleClassInfo.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    usecase.addServiceBuilder(this.getServiceBuilder((ClassInfo)handleClassInfo));
                    this.useCases.add(new UseCaseWrap(type, (UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents>)usecase));
                    logger.info("@@@@ Registered use case for event lister --> " + usecase.getClass().getSimpleName() + "[" + type + "]");
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            });
        }
    }

    private String getEventType(AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("eventType");
        }).orElseThrow();
    }

    public final void fire(DomainEvent domainEvent) {
        final DomainEvent event = Objects.requireNonNull(domainEvent);
        this.useCases.stream().filter(useCaseWrap -> useCaseWrap.eventType.equals(domainEvent.type)).forEach(useCaseWrap -> {
            UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents> useCase = useCaseWrap.usecase;
            useCase.addRepository(new DomainEventRepository(){

                public List<DomainEvent> getEventsBy(String aggregateRootId) {
                    return ApplicationEventDrive.this.repository.getEventsBy(event.getAggregateName(), aggregateRootId);
                }

                public List<DomainEvent> getEventsBy(String aggregate, String aggregateRootId) {
                    return ApplicationEventDrive.this.repository.getEventsBy(aggregate, aggregateRootId);
                }
            });
            logger.info("Use case handler to event --> " + event.type);
            UseCaseHandler.getInstance().asyncExecutor(useCase, (UseCase.RequestValues)new TriggeredEvent(event)).subscribe((Flow.Subscriber)this.subscriberEvent);
        });
    }

    private ServiceBuilder getServiceBuilder(ClassInfo handleClassInfo) {
        AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(ExtensionService.class.getName());
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            ServiceBuilder serviceBuilder = new ServiceBuilder();
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            Object[] list = (Object[])paramVals.getValue("value");
            Stream.of(list).forEach(className -> {
                try {
                    AnnotationClassRef ref = (AnnotationClassRef)className;
                    serviceBuilder.addService(ref.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.log(Level.SEVERE, "ERROR over service builder", e);
                    throw new ServiceBuildException(e);
                }
            });
            return serviceBuilder;
        }).orElse(new ServiceBuilder());
    }

    private static class UseCaseWrap {
        private final UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents> usecase;
        private final String eventType;

        public UseCaseWrap(String eventType, UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents> usecase) {
            this.usecase = usecase;
            this.eventType = eventType;
        }
    }
}

