/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.application;

import co.com.sofka.business.annotation.QueryHandles;
import co.com.sofka.business.annotation.QueryPath;
import co.com.sofka.business.repository.QueryMapperRepository;
import co.com.sofka.business.sync.ViewModelExecutor;
import co.com.sofka.infraestructure.handle.QueryExecutor;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationQueryExecutor
extends QueryExecutor {
    private static final Logger logger = Logger.getLogger(ApplicationQueryExecutor.class.getName());
    private final QueryMapperRepository queryMapperRepo;
    private final String packageQueries;

    public ApplicationQueryExecutor(String packageQueries, QueryMapperRepository queryMapperRepo) {
        this.queryMapperRepo = queryMapperRepo;
        this.packageQueries = packageQueries;
        this.initialize();
    }

    private void initialize() {
        try (ScanResult result = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{this.packageQueries}).scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(QueryHandles.class.getName());
            classInfos.parallelStream().forEach(handleClassInfo -> {
                try {
                    AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(QueryPath.class.getName());
                    String path = this.getPath((ClassInfo)handleClassInfo, annotationInfo);
                    ViewModelExecutor handle = (ViewModelExecutor)handleClassInfo.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.put(path, (Function)handle.witchQueryMapperRepository(this.queryMapperRepo));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.log(Level.SEVERE, "An error caused by the mapper generic and cast view model", e);
                }
            });
        }
    }

    private String getPath(ClassInfo handleClassInfo, AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("name");
        }).orElse(handleClassInfo.loadClass().getCanonicalName().toLowerCase().replace(this.packageQueries + ".", ""));
    }
}

