/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.application;

import co.com.sofka.application.ServiceBuildException;
import co.com.sofka.business.annotation.EventListener;
import co.com.sofka.business.annotation.ExtensionService;
import co.com.sofka.business.generic.ServiceBuilder;
import co.com.sofka.business.generic.UseCase;
import co.com.sofka.business.generic.UseCaseHandler;
import co.com.sofka.business.repository.DomainEventRepository;
import co.com.sofka.business.support.ResponseEvents;
import co.com.sofka.business.support.TriggeredEvent;
import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.infraestructure.asyn.SubscriberEvent;
import co.com.sofka.infraestructure.repository.EventStoreRepository;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ApplicationEventDrive {
    private static final Logger logger = Logger.getLogger(ApplicationEventDrive.class.getName());
    private final Set<UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents>> useCases;
    private final SubscriberEvent subscriberEvent;
    private final EventStoreRepository repository;
    private final String packageUseCase;

    public ApplicationEventDrive(String packageUseCase, SubscriberEvent subscriberEvent) {
        this(packageUseCase, subscriberEvent, null);
    }

    public ApplicationEventDrive(String packageUseCase, SubscriberEvent subscriberEvent, EventStoreRepository repository) {
        this.subscriberEvent = subscriberEvent;
        this.packageUseCase = packageUseCase;
        this.repository = repository;
        this.useCases = new HashSet<UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents>>();
        this.initialize();
    }

    private void initialize() {
        logger.info("---- Registered Event Listener Use Case -----");
        try (ScanResult result = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{this.packageUseCase}).scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(EventListener.class.getName());
            classInfos.parallelStream().forEach(handleClassInfo -> {
                try {
                    UseCase usecase = (UseCase)handleClassInfo.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    usecase.addServiceBuilder(this.getServiceBuilder((ClassInfo)handleClassInfo));
                    this.useCases.add((UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents>)usecase);
                    logger.info("@@@@ Registered use case for event lister --> " + usecase.getClass().getName());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            });
        }
    }

    public final void fire(DomainEvent domainEvent) {
        final DomainEvent event = Objects.requireNonNull(domainEvent);
        this.useCases.forEach(useCase -> {
            if (this.matchDomainEvent(event).withRequestOf((UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents>)useCase)) {
                useCase.addRepository(new DomainEventRepository(){

                    public List<DomainEvent> getEventsBy(String aggregateRootId) {
                        return ApplicationEventDrive.this.repository.getEventsBy(event.getAggregateName(), aggregateRootId);
                    }

                    public List<DomainEvent> getEventsBy(String aggregate, String aggregateRootId) {
                        return ApplicationEventDrive.this.repository.getEventsBy(aggregate, aggregateRootId);
                    }
                });
                UseCaseHandler.getInstance().asyncExecutor(useCase, (UseCase.RequestValues)new TriggeredEvent(event)).subscribe((Flow.Subscriber)this.subscriberEvent);
            }
        });
    }

    private ServiceBuilder getServiceBuilder(ClassInfo handleClassInfo) {
        AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(ExtensionService.class.getName());
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            ServiceBuilder serviceBuilder = new ServiceBuilder();
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            Object[] list = (Object[])paramVals.getValue("value");
            Stream.of(list).forEach(className -> {
                try {
                    AnnotationClassRef ref = (AnnotationClassRef)className;
                    serviceBuilder.addService(ref.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.log(Level.SEVERE, "ERROR over service builder", e);
                    throw new ServiceBuildException(e);
                }
            });
            return serviceBuilder;
        }).orElse(new ServiceBuilder());
    }

    private boolean isMatchWithAEvent(DomainEvent domainEvent, Method m, Class<?>[] params) {
        Type returnType;
        boolean matchWithAEvent = false;
        if (params[0].getCanonicalName().equals(TriggeredEvent.class.getCanonicalName()) && (returnType = m.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            matchWithAEvent = ((Class)type.getActualTypeArguments()[0]).getCanonicalName().equals(domainEvent.getClass().getCanonicalName());
        }
        return matchWithAEvent;
    }

    private ConditionalRequestUseCase matchDomainEvent(DomainEvent domainEvent) {
        return useCaseCasted -> {
            UseCase useCase = Objects.requireNonNull(useCaseCasted);
            String target = "executeUseCase";
            boolean matchWithAEvent = false;
            try {
                Method m = useCase.getClass().getMethod("executeUseCase", TriggeredEvent.class);
                if (target.equals(m.getName())) {
                    Class<?>[] params = m.getParameterTypes();
                    matchWithAEvent = this.isMatchWithAEvent(domainEvent, m, params);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return matchWithAEvent;
        };
    }

    @FunctionalInterface
    private static interface ConditionalRequestUseCase {
        public boolean withRequestOf(UseCase<TriggeredEvent<? extends DomainEvent>, ResponseEvents> var1);
    }
}

