/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.application;

import co.com.sofka.business.annotation.CommandHandles;
import co.com.sofka.business.annotation.CommandType;
import co.com.sofka.business.asyn.UseCaseExecutor;
import co.com.sofka.business.generic.UseCaseHandler;
import co.com.sofka.infraestructure.asyn.SubscriberEvent;
import co.com.sofka.infraestructure.handle.CommandExecutor;
import co.com.sofka.infraestructure.repository.EventStoreRepository;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationCommandExecutor
extends CommandExecutor {
    private static final Logger logger = Logger.getLogger(ApplicationCommandExecutor.class.getName());
    private final SubscriberEvent subscriberEvent;
    private final EventStoreRepository repository;
    private final String packageUseCase;

    public ApplicationCommandExecutor(String packageUseCase, SubscriberEvent subscriberEvent, EventStoreRepository repository) {
        this.subscriberEvent = subscriberEvent;
        this.repository = repository;
        this.packageUseCase = packageUseCase;
        this.initialize();
    }

    private void initialize() {
        logger.info("---- Registered Commands -----");
        try (ScanResult result = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{this.packageUseCase}).scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(CommandHandles.class.getName());
            classInfos.parallelStream().forEach(handleClassInfo -> {
                AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(CommandType.class.getName());
                String type = this.getCommandType((ClassInfo)handleClassInfo, annotationInfo);
                String aggregate = this.getAggregate(annotationInfo);
                this.addHandle((ClassInfo)handleClassInfo, aggregate, type);
            });
        }
    }

    private String getCommandType(ClassInfo handleClassInfo, AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("name");
        }).orElse(handleClassInfo.loadClass().getCanonicalName().toLowerCase().replace(this.packageUseCase + ".", ""));
    }

    private String getAggregate(AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("aggregate");
        }).orElse("default");
    }

    private void addHandle(ClassInfo handleClassInfo, String aggregate, String type) {
        try {
            UseCaseExecutor handle = (UseCaseExecutor)handleClassInfo.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.put(type, (Consumer)handle.withSubscriberEvent((Flow.Subscriber)this.subscriberEvent).withUseCaseHandler(UseCaseHandler.getInstance()).withDomainEventRepo(aggregateRootId -> this.repository.getEventsBy(aggregate, aggregateRootId)));
            String message = String.format("@@@@ %s Registered handle command with type --> %s", aggregate, type);
            logger.info(message);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "There is a error inside register command type -->" + type);
        }
    }
}

