package co.colombiasoftware.smcore.Session;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import co.colombiasoftware.smcore.Error;
import co.colombiasoftware.smcore.R;

/**
 * Created by anibal on 24/07/16.
 */
public class Session {
    public static void validateSession(Context context, Activity activity)
    {
        verifyConnection(context, activity);

        try {
            Context contextSm = context.createPackageContext("net.colombiasoftware.silogtranmovil", 0);
            SharedPreferences sharedPref = contextSm.getSharedPreferences("DatosSesionSilogtranMovil", Context.MODE_WORLD_READABLE);
            String userLogin = sharedPref.getString("usuarioLogin", "");

            if(userLogin.equals("")){
                Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage("net.colombiasoftware.silogtranmovil");
                context.startActivity(launchIntent);
                System.exit(0);
            }
        } catch (PackageManager.NameNotFoundException e) {
            Error.showSmCoreError(context, e.getMessage());
        }
    }

    public static SharedPreferences getSesion(Context context, Activity activity)
    {
        SharedPreferences sharedPref = null;

        try {
            Context contextSm = context.createPackageContext("net.colombiasoftware.silogtranmovil", 0);
            sharedPref = contextSm.getSharedPreferences("DatosSesionSilogtranMovil", Context.MODE_WORLD_READABLE);

            return sharedPref;
        } catch (PackageManager.NameNotFoundException e) {
            Error.showSmCoreError(context, e.getMessage());
        }

        return sharedPref;
    }

    public static void verifyConnection(Context context, Activity activity){
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();

        if(!(activeNetwork != null && activeNetwork.isConnectedOrConnecting())){
            Error.showSmCoreError(context, R.string.errorNoConnection);
        }
    }
}
