package co.colombiasoftware.smcore.Http;

import android.content.Context;

import org.json.JSONException;
import org.json.JSONObject;

import co.colombiasoftware.smcore.Error;

/**
 * Created by anibal on 24/07/16.
 */
public class SmJsonResponse {
    private boolean success;
    private String data;
    private String msg;

    public SmJsonResponse(Context context, JSONObject jsonObject)
    {
        try {
            this.success = jsonObject.getBoolean("satisfactorio");
            this.data = jsonObject.getString("respuesta");
            this.msg = jsonObject.getString("mensaje");
        } catch (JSONException e) {
            Error.showSmCoreError(context, e.getMessage());
        }
    }

    public boolean isSuccess() {
        return success;
    }

    public String getData() {
        return data;
    }

    public String getMsg() {
        return msg;
    }
}
