/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.test;

import co.cask.cdap.api.annotation.Description;
import co.cask.cdap.api.annotation.Name;
import co.cask.cdap.api.annotation.Plugin;
import co.cask.wrangler.api.Directive;
import co.cask.wrangler.api.DirectiveLoadException;
import co.cask.wrangler.api.DirectiveNotFoundException;
import co.cask.wrangler.api.DirectiveParseException;
import co.cask.wrangler.api.DirectiveRegistry;
import co.cask.wrangler.api.RecipeException;
import co.cask.wrangler.api.RecipeParser;
import co.cask.wrangler.api.RecipePipeline;
import co.cask.wrangler.executor.RecipePipelineExecutor;
import co.cask.wrangler.parser.GrammarBasedParser;
import co.cask.wrangler.parser.MigrateToV2;
import co.cask.wrangler.registry.CompositeDirectiveRegistry;
import co.cask.wrangler.registry.SystemDirectiveRegistry;
import co.cask.wrangler.test.api.TestRecipe;
import java.util.ArrayList;

public final class TestingRig {
    private TestingRig() {
    }

    public static RecipePipeline pipeline(Class<? extends Directive> directive, TestRecipe recipe) throws RecipeException, DirectiveParseException, DirectiveLoadException, DirectiveNotFoundException {
        TestingRig.verify(directive);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(directive.getPackage().getName());
        CompositeDirectiveRegistry registry = new CompositeDirectiveRegistry(new DirectiveRegistry[]{new SystemDirectiveRegistry(packages)});
        String migrate = new MigrateToV2(recipe.toArray()).migrate();
        GrammarBasedParser parser = new GrammarBasedParser(migrate, (DirectiveRegistry)registry);
        parser.initialize(null);
        RecipePipelineExecutor pipeline = new RecipePipelineExecutor();
        pipeline.initialize((RecipeParser)parser, null);
        return pipeline;
    }

    public static RecipeParser parser(Class<? extends Directive> directive, String[] recipe) throws RecipeException, DirectiveParseException, DirectiveLoadException, DirectiveNotFoundException {
        TestingRig.verify(directive);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(directive.getCanonicalName());
        CompositeDirectiveRegistry registry = new CompositeDirectiveRegistry(new DirectiveRegistry[]{new SystemDirectiveRegistry()});
        String migrate = new MigrateToV2(recipe).migrate();
        GrammarBasedParser parser = new GrammarBasedParser(migrate, (DirectiveRegistry)registry);
        parser.initialize(null);
        return parser;
    }

    private static void verify(Class<? extends Directive> directive) {
        String classz = directive.getCanonicalName();
        Plugin plugin = directive.getAnnotation(Plugin.class);
        if (plugin == null || !plugin.type().equalsIgnoreCase("directive")) {
            throw new IllegalArgumentException(String.format("Class '%s' @Plugin annotation is not of type '%s', Set it as @Plugin(type=UDD.Type)", classz, "directive"));
        }
        Name name = directive.getAnnotation(Name.class);
        if (name == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing @Name annotation. E.g. @Name(\"directive-name\")", classz));
        }
        Description description = directive.getAnnotation(Description.class);
        if (description == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing @Description annotation. E.g. @Description(\"this is what my directive does\")", classz));
        }
    }
}

