/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api.parser;

import co.cask.wrangler.api.annotations.PublicEvolving;
import co.cask.wrangler.api.parser.TokenType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;

@PublicEvolving
public final class TokenDefinition
implements Serializable {
    private final int ordinal;
    private final boolean optional;
    private final String name;
    private final TokenType type;
    private final String label;

    public TokenDefinition(String name, TokenType type, String label, int ordinal, boolean optional) {
        this.name = name;
        this.type = type;
        this.label = label;
        this.ordinal = ordinal;
        this.optional = optional;
    }

    public String label() {
        return this.label;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean optional() {
        return this.optional;
    }

    public String name() {
        return this.name;
    }

    public TokenType type() {
        return this.type;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("name", this.name);
        object.addProperty("type", this.type.name());
        object.addProperty("ordinal", (Number)this.ordinal);
        object.addProperty("optional", Boolean.valueOf(this.optional));
        object.addProperty("label", this.label);
        return object;
    }
}

