/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api.lineage;

import co.cask.wrangler.api.annotations.PublicEvolving;
import co.cask.wrangler.api.lineage.Mutation;
import co.cask.wrangler.api.lineage.MutationType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@PublicEvolving
public final class MutationDefinition
implements Serializable {
    private final String directive;
    private final List<Mutation> mutations;

    private MutationDefinition(String directive, List<Mutation> mutations) {
        this.directive = directive;
        this.mutations = mutations;
    }

    public String directive() {
        return this.directive;
    }

    public Iterator<Mutation> iterator() {
        return this.mutations.iterator();
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("directive", this.directive);
        JsonArray array = new JsonArray();
        for (Mutation mutation : this.mutations) {
            array.add(mutation.toJson());
        }
        object.add("mutations", (JsonElement)array);
        return object;
    }

    public static Builder builder(String directive) {
        return new Builder(directive);
    }

    public static class Builder {
        private final String directive;
        private final List<Mutation> mutations;

        public Builder(String directive) {
            this.directive = directive;
            this.mutations = new ArrayList<Mutation>();
        }

        public void addMutation(String column, MutationType type) {
            this.addMutation(column, type, null);
        }

        public void addMutation(String column, MutationType type, String description) {
            this.mutations.add(new Mutation(column, type, description));
        }

        public MutationDefinition build() {
            return new MutationDefinition(this.directive, this.mutations);
        }
    }
}

