/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api.parser;

import co.cask.wrangler.api.annotations.PublicEvolving;
import co.cask.wrangler.api.parser.Token;
import co.cask.wrangler.api.parser.TokenType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

@PublicEvolving
public class ColumnNameList
implements Token {
    private List<String> values = new ArrayList<String>();

    public ColumnNameList(List<String> values) {
        this.values = values;
    }

    @Override
    public List<String> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.COLUMN_NAME_LIST;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TokenType.COLUMN_NAME_LIST.name());
        JsonArray array = new JsonArray();
        for (String value : this.values) {
            array.add((JsonElement)new JsonPrimitive(value));
        }
        object.add("value", (JsonElement)array);
        return object;
    }
}

