/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DirectiveConfig {
    private Set<String> exclusions = new HashSet<String>();
    private Map<String, String> aliases = new HashMap<String, String>();

    public boolean hasAlias(String directive) {
        return this.aliases != null && this.aliases.containsKey(directive);
    }

    public String getAliasName(String directive) {
        return this.aliases.get(directive);
    }

    public Map<String, List<String>> getReverseAlias() {
        HashMap<String, List<String>> reverse = new HashMap<String, List<String>>();
        if (this.aliases == null) {
            return reverse;
        }
        for (Map.Entry<String, String> alias : this.aliases.entrySet()) {
            List<String> list = reverse.containsKey(alias.getValue()) ? (List)reverse.get(alias.getValue()) : new ArrayList<String>();
            list.add(alias.getKey());
            reverse.put(alias.getValue(), list);
        }
        return reverse;
    }

    public boolean isExcluded(String directive) {
        return this.exclusions != null && this.exclusions.contains(directive);
    }

    public JsonElement toJson() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("exclusions", gson.toJsonTree(this.exclusions));
        object.add("aliases", gson.toJsonTree(this.aliases));
        return object;
    }
}

