/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api.parser;

import co.cask.wrangler.api.annotations.PublicEvolving;
import co.cask.wrangler.api.parser.Token;
import co.cask.wrangler.api.parser.TokenType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;

@PublicEvolving
public class BoolList
implements Token {
    private List<Boolean> values;

    public BoolList(List<Boolean> values) {
        this.values = values;
    }

    @Override
    public List<Boolean> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.BOOLEAN_LIST;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TokenType.BOOLEAN_LIST.name());
        JsonArray array = new JsonArray();
        for (Boolean value : this.values) {
            array.add((JsonElement)new JsonPrimitive(value));
        }
        object.add("value", (JsonElement)array);
        return object;
    }
}

