/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api;

import co.cask.cdap.api.annotation.Description;
import co.cask.cdap.api.annotation.Name;
import co.cask.wrangler.api.Directive;
import co.cask.wrangler.api.annotations.Categories;
import co.cask.wrangler.api.parser.UsageDefinition;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public final class DirectiveInfo {
    private String name;
    private UsageDefinition definition;
    private Class<?> directive;
    private String usage;
    private String description;
    private Scope scope;
    private boolean deprecated;
    private String[] categories;

    public DirectiveInfo(Scope scope, Class<?> directive) throws IllegalAccessException, InstantiationException {
        this.scope = scope;
        this.directive = directive;
        Object object = directive.newInstance();
        this.definition = ((Directive)object).define();
        this.usage = this.definition != null ? this.definition.toString() : "No definition available for directive '" + directive + "'";
        this.name = directive.getAnnotation(Name.class).value();
        Description desc = directive.getAnnotation(Description.class);
        this.description = desc == null ? "No description specified for directive class '" + directive.getSimpleName() + "'" : desc.value();
        Deprecated annotation = directive.getAnnotation(Deprecated.class);
        this.deprecated = annotation != null;
        Categories category = directive.getAnnotation(Categories.class);
        this.categories = category == null ? new String[]{"default"} : category.categories();
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public Scope scope() {
        return this.scope;
    }

    public String name() {
        return this.name;
    }

    public String usage() {
        return this.usage;
    }

    public String description() {
        return this.description;
    }

    public UsageDefinition definition() {
        return this.definition;
    }

    public String[] categories() {
        return this.categories;
    }

    public final Directive instance() throws IllegalAccessException, InstantiationException {
        return (Directive)this.directive.newInstance();
    }

    public final JsonObject toJson() {
        JsonObject response = new JsonObject();
        response.addProperty("plugin", this.name);
        response.addProperty("usage", this.usage);
        response.addProperty("description", this.description);
        response.addProperty("class", this.directive.getCanonicalName());
        response.add("definition", this.definition.toJson());
        response.addProperty("scope", this.scope.name());
        response.addProperty("deprecated", Boolean.valueOf(this.deprecated));
        JsonArray array = new JsonArray();
        for (String category : this.categories) {
            array.add((JsonElement)new JsonPrimitive(category));
        }
        response.add("categories", (JsonElement)array);
        return response;
    }

    public static enum Scope {
        SYSTEM,
        USER;

    }
}

