/*
 * Decompiled with CFR 0.152.
 */
package co.cask.wrangler.api.parser;

import co.cask.wrangler.api.annotations.PublicEvolving;
import co.cask.wrangler.api.parser.Token;
import co.cask.wrangler.api.parser.TokenType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

@PublicEvolving
public class Properties
implements Token {
    private Map<String, Token> values;

    public Properties(Map<String, Token> values) {
        this.values = values;
    }

    @Override
    public Map<String, Token> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.PROPERTIES;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, Token> entry : this.values.entrySet()) {
            object.add(entry.getKey(), entry.getValue().toJson());
        }
        return object;
    }
}

