/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import co.cask.tigon.logging.LogConfiguration;
import co.cask.tigon.logging.LogEvent;
import co.cask.tigon.logging.LogWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LogFileWriter
implements LogWriter {
    static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    LogConfiguration config;
    FileSystem fileSystem;
    private FSDataOutputStream out;

    @Override
    public void configure(LogConfiguration config) throws IOException {
        this.config = config;
        this.fileSystem = config.getFileSystem();
        this.createPath(config.getLogFilePath());
        this.openFileForWrite(config.getLogFilePath(), this.makeFileName(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(LogEvent event) throws IOException {
        LogFileWriter logFileWriter = this;
        synchronized (logFileWriter) {
            this.persistMessage(this.formatMessage(event));
            if (this.getCurrentFileSize() > this.config.getSizeThreshold()) {
                this.roll();
                this.openFileForWrite(this.config.getLogFilePath(), this.makeFileName(0));
            }
        }
    }

    private void roll() throws IOException {
        this.closeFile();
        this.deleteFile(this.config.getLogFilePath(), this.makeFileName(this.config.getMaxInstances() - 1));
        for (int i = this.config.getMaxInstances() - 1; i > 0; --i) {
            this.renameFile(this.config.getLogFilePath(), this.makeFileName(i - 1), this.makeFileName(i));
        }
    }

    @Override
    public void close() throws IOException {
        this.closeFile();
    }

    String formatMessage(LogEvent event) {
        return String.format("%s [%s] %s", event.getTag(), event.getLevel(), event.getMessage());
    }

    String makeFileName(int instance) {
        if (instance == 0) {
            return this.config.getLogFileName();
        }
        return String.format("%s.%d", this.config.getLogFileName(), instance);
    }

    void createPath(String path) throws IOException {
        this.fileSystem.mkdirs(new Path(path));
    }

    void openFileForWrite(String path, String name) throws IOException {
        Path filePath = new Path(path, name);
        this.out = !this.fileSystem.exists(filePath) ? this.fileSystem.create(filePath) : this.fileSystem.append(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile() throws IOException {
        LogFileWriter logFileWriter = this;
        synchronized (logFileWriter) {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistMessage(String message) throws IOException {
        LogFileWriter logFileWriter = this;
        synchronized (logFileWriter) {
            this.out.write(message.getBytes(CHARSET_UTF8));
            this.out.write(10);
            this.out.hflush();
        }
    }

    @Override
    public long getWritePosition() throws IOException {
        return this.getCurrentFileSize();
    }

    long getCurrentFileSize() throws IOException {
        return this.out.getPos();
    }

    void deleteFile(String path, String name) throws IOException {
        if (this.fileSystem.exists(new Path(path, name))) {
            this.fileSystem.delete(new Path(path, name), false);
        }
    }

    void renameFile(String path, String oldName, String newName) throws IOException {
        Path oldPath = new Path(path, oldName);
        if (!this.fileSystem.exists(oldPath)) {
            return;
        }
        Path newPath = new Path(path, newName);
        this.fileSystem.rename(oldPath, newPath);
    }
}

