/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import co.cask.tigon.logging.LogConfiguration;
import co.cask.tigon.logging.LogFileWriter;
import co.cask.tigon.logging.LogReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LogFileReader
implements LogReader {
    LogConfiguration config;
    FileSystem fileSystem;

    @Override
    public void configure(LogConfiguration config) throws IOException {
        this.config = config;
        this.fileSystem = config.getFileSystem();
    }

    @Override
    public List<String> tail(int sizeToRead, long writePos) throws IOException {
        return this.tail(new ArrayList<String>(), 0, sizeToRead, writePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> tail(ArrayList<String> lines, int i, long size, long sizeHint) throws IOException {
        Path path = new Path(this.config.getLogFilePath(), this.makeFileName(i));
        if (!this.fileSystem.exists(path)) {
            return lines;
        }
        FileStatus status = this.fileSystem.getFileStatus(path);
        if (!status.isFile()) {
            return lines;
        }
        long fileSize = sizeHint >= 0L ? sizeHint : (i > 0 ? status.getLen() : this.determineTrueFileSize(path, status));
        long seekPos = 0L;
        long bytesToRead = size;
        if (fileSize >= size) {
            seekPos = fileSize - size;
        } else {
            this.tail(lines, i + 1, size - fileSize, -1L);
            bytesToRead = fileSize;
        }
        byte[] bytes = new byte[(int)bytesToRead];
        FSDataInputStream input = this.fileSystem.open(path);
        try {
            if (seekPos > 0L) {
                input.seek(seekPos);
            }
            input.readFully(bytes);
        }
        finally {
            input.close();
        }
        int pos = 0;
        if (seekPos > 0L) {
            while ((long)pos < bytesToRead && bytes[pos] != 10) {
                ++pos;
            }
            ++pos;
        }
        while ((long)pos < bytesToRead) {
            int start = pos;
            while ((long)pos < bytesToRead && bytes[pos] != 10) {
                ++pos;
            }
            if (pos != start) {
                String line = new String(bytes, start, pos - start, LogFileWriter.CHARSET_UTF8);
                lines.add(line);
            }
            ++pos;
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long determineTrueFileSize(Path path, FileStatus status) throws IOException {
        FSDataInputStream stream = this.fileSystem.open(path);
        try {
            long trueSize;
            stream.seek(status.getLen());
            byte[] buffer = new byte[0x100000];
            while (stream.read(buffer, 0, buffer.length) >= 0) {
            }
            long l = trueSize = stream.getPos();
            return l;
        }
        finally {
            stream.close();
        }
    }

    String makeFileName(int instance) {
        if (instance == 0) {
            return this.config.getLogFileName();
        }
        return String.format("%s.%d", this.config.getLogFileName(), instance);
    }
}

