/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import co.cask.tigon.conf.CConfiguration;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;

public class LogConfiguration {
    private final String account;
    private final String application;
    private final String flow;
    private final String prefix;
    private final String path;
    private final FileSystem fs;
    private final long threshold;
    private final int instances;
    public static final String CFG_ROLL_THRESHOLD = "logfile.roll.size";
    public static final String CFG_ROLL_INSTANCES = "logfile.roll.instances";
    public static final long DEFAULT_ROLL_THRESHOLD = 0x400000L;
    public static final int DEFAULT_ROLL_INSTANCES = 5;

    public LogConfiguration(FileSystem fs, CConfiguration config, String pathPrefix, String tag) throws IOException {
        String[] splits = tag.split(":");
        if (splits.length < 3) {
            throw new IOException("Invalid log tag '" + tag + "'");
        }
        String account = splits[0];
        String app = splits[1];
        String flow = splits[2];
        this.fs = fs;
        this.account = account;
        this.application = app;
        this.flow = flow;
        this.prefix = pathPrefix;
        this.path = String.format("%s/%s/%s/", pathPrefix, this.application, flow);
        this.threshold = config.getLong(CFG_ROLL_THRESHOLD, 0x400000L);
        this.instances = config.getInt(CFG_ROLL_INSTANCES, 5);
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public String getLogFileName() {
        return "flow.log";
    }

    public String getLogFilePath() {
        return this.path;
    }

    public long getSizeThreshold() {
        return this.threshold;
    }

    public int getMaxInstances() {
        return this.instances;
    }
}

