/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import co.cask.tigon.conf.CConfiguration;
import co.cask.tigon.logging.LogConfiguration;
import co.cask.tigon.logging.LogEvent;
import co.cask.tigon.logging.LogFileReader;
import co.cask.tigon.logging.LogFileWriter;
import co.cask.tigon.logging.LogWriter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollector {
    private static final Logger LOG = LoggerFactory.getLogger(LogCollector.class);
    ConcurrentMap<String, LogWriter> loggers = Maps.newConcurrentMap();
    private final String pathPrefix;
    private final Configuration hConfig;
    private final CConfiguration config;
    private FileSystem fs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystem() throws IOException {
        if (this.fs == null) {
            LogCollector logCollector = this;
            synchronized (logCollector) {
                if (this.fs == null) {
                    this.fs = FileSystem.get((Configuration)this.hConfig);
                    if (this.fs instanceof LocalFileSystem) {
                        this.fs = ((LocalFileSystem)this.fs).getRawFileSystem();
                    }
                }
            }
        }
        return this.fs;
    }

    public LogCollector(CConfiguration config, Configuration hConfig) {
        this.pathPrefix = config.get("log.collection.root", "data/logs");
        this.hConfig = hConfig;
        this.config = config;
        LOG.info("Root directory for log collection is " + this.pathPrefix);
    }

    public void log(LogEvent event) {
        try {
            this.getLogger(event.getTag()).log(event);
        }
        catch (IOException e) {
            LOG.warn("Failed to log event for " + event.getTag() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogWriter getLogger(String tag) throws IOException {
        LogWriter logger = (LogWriter)this.loggers.get(tag);
        if (logger == null) {
            LogCollector logCollector = this;
            synchronized (logCollector) {
                logger = (LogWriter)this.loggers.get(tag);
                if (logger == null) {
                    LogConfiguration conf = new LogConfiguration(this.getFileSystem(), this.config, this.pathPrefix, tag);
                    logger = new LogFileWriter();
                    logger.configure(conf);
                    this.loggers.put(tag, logger);
                }
            }
        }
        return logger;
    }

    public List<String> tail(String tag, int size) throws IOException {
        LogWriter writer = (LogWriter)this.loggers.get(tag);
        long sizeHint = -1L;
        if (writer != null && !(this.fs instanceof RawLocalFileSystem)) {
            sizeHint = writer.getWritePosition();
        }
        LogConfiguration conf = new LogConfiguration(this.getFileSystem(), this.config, this.pathPrefix, tag);
        LogFileReader reader = new LogFileReader();
        reader.configure(conf);
        return reader.tail(size, sizeHint);
    }

    public void close() throws IOException {
        for (Map.Entry entry : this.loggers.entrySet()) {
            ((LogWriter)entry.getValue()).close();
            this.loggers.remove(entry.getKey());
        }
    }
}

