/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import co.cask.tigon.logging.LogAppender;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAppenderInitializer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LogAppenderInitializer.class);
    private static final ConcurrentMap<String, String> initMap = Maps.newConcurrentMap();
    private final LogAppender logAppender;

    @Inject
    public LogAppenderInitializer(LogAppender logAppender) {
        this.logAppender = logAppender;
    }

    public void initialize() {
        this.initialize("ROOT");
    }

    public void initialize(String rootLoggerName) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            LOG.warn("LoggerFactory is not a logback LoggerContext. No log appender is added. Logback might not be in the classpath");
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactory;
        ch.qos.logback.classic.Logger rootLogger = loggerContext.getLogger(rootLoggerName);
        if (initMap.putIfAbsent(rootLoggerName, this.logAppender.getName()) != null) {
            LOG.trace("Log appender {} is already initialized.", (Object)this.logAppender.getName());
            return;
        }
        LOG.info("Initializing log appender {}", (Object)this.logAppender.getName());
        StatusManager statusManager = loggerContext.getStatusManager();
        OnConsoleStatusListener onConsoleListener = new OnConsoleStatusListener();
        statusManager.add((StatusListener)onConsoleListener);
        this.logAppender.setContext((Context)loggerContext);
        this.logAppender.start();
        rootLogger.addAppender((Appender)this.logAppender);
    }

    @Override
    public void close() {
        if (this.logAppender != null) {
            LOG.info("Stopping log appender {}", (Object)this.logAppender.getName());
            this.logAppender.stop();
        }
    }
}

