/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.logging;

import co.cask.tigon.logging.LoggingContext;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractLoggingContext
implements LoggingContext {
    private Map<String, LoggingContext.SystemTag> systemTags = Maps.newHashMap();

    protected final void setSystemTag(String name, String value) {
        this.systemTags.put(name, new SystemTagImpl(name, value));
    }

    protected final String getSystemTag(String name) {
        return this.systemTags.get(name).getValue();
    }

    @Override
    public Collection<LoggingContext.SystemTag> getSystemTags() {
        return Collections.unmodifiableCollection(this.systemTags.values());
    }

    @Override
    public Map<String, LoggingContext.SystemTag> getSystemTagsMap() {
        return Collections.unmodifiableMap(this.systemTags);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("systemTags", this.systemTags).toString();
    }

    private static final class SystemTagImpl
    implements LoggingContext.SystemTag {
        private final String name;
        private final String value;

        private SystemTagImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
        }
    }
}

