/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.lang.jar;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ProgramClassLoader.class);

    public ProgramClassLoader(File unpackedJarDir, ClassLoader parentDelegate) {
        super(ProgramClassLoader.getClassPathUrls(unpackedJarDir), parentDelegate);
    }

    private static URL[] getClassPathUrls(File unpackedJarDir) {
        LinkedList<URL> classPathUrls = new LinkedList<URL>();
        try {
            classPathUrls.add(unpackedJarDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Error in adding unpackedJarDir to classPathUrls", (Throwable)e);
        }
        try {
            classPathUrls.addAll(ProgramClassLoader.getJarURLs(unpackedJarDir));
        }
        catch (MalformedURLException e) {
            LOG.error("Error in adding jar URLs to classPathUrls", (Throwable)e);
        }
        try {
            classPathUrls.addAll(ProgramClassLoader.getJarURLs(new File(unpackedJarDir, "lib")));
        }
        catch (MalformedURLException e) {
            LOG.error("Error in adding jar URLs to classPathUrls", (Throwable)e);
        }
        return classPathUrls.toArray(new URL[classPathUrls.size()]);
    }

    private static List<URL> getJarURLs(File dir) throws MalformedURLException {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        LinkedList<URL> urls = new LinkedList<URL>();
        if (files != null) {
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
        }
        return urls;
    }
}

