/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.lang.jar;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.twill.filesystem.Location;

public class BundleJarUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(Location jarLocation) throws IOException {
        URI uri = jarLocation.toURI();
        if ("file".equals(uri.getScheme())) {
            JarFile jarFile = new JarFile(new File(uri));
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            finally {
                jarFile.close();
            }
        }
        JarInputStream is = new JarInputStream(new BufferedInputStream(jarLocation.getInputStream()));
        try {
            Manifest manifest = is.getManifest();
            if (manifest != null) {
                Manifest manifest2 = manifest;
                return manifest2;
            }
            JarEntry jarEntry = is.getNextJarEntry();
            while (jarEntry != null) {
                if ("META-INF/MANIFEST.MF".equals(jarEntry.getName())) {
                    Manifest manifest3 = new Manifest(is);
                    return manifest3;
                }
                jarEntry = is.getNextJarEntry();
            }
        }
        finally {
            is.close();
        }
        return null;
    }

    public static InputSupplier<InputStream> getEntry(final Location jarLocation, final String entryName) throws IOException {
        Preconditions.checkArgument((jarLocation != null ? 1 : 0) != 0);
        Preconditions.checkArgument((entryName != null ? 1 : 0) != 0);
        final URI uri = jarLocation.toURI();
        if ("file".equals(uri.getScheme())) {
            return new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    final JarFile jarFile = new JarFile(new File(uri));
                    ZipEntry entry = jarFile.getEntry(entryName);
                    if (entry == null) {
                        throw new IOException("Entry not found for " + entryName);
                    }
                    return new FilterInputStream(jarFile.getInputStream(entry)){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void close() throws IOException {
                            try {
                                super.close();
                            }
                            finally {
                                jarFile.close();
                            }
                        }
                    };
                }
            };
        }
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                JarInputStream is = new JarInputStream(jarLocation.getInputStream());
                JarEntry entry = is.getNextJarEntry();
                while (entry != null) {
                    if (entryName.equals(entry.getName())) {
                        return is;
                    }
                    entry = is.getNextJarEntry();
                }
                Closeables.closeQuietly((Closeable)is);
                throw new IOException("Entry not found for " + entryName);
            }
        };
    }

    public static File unpackProgramJar(Location programJarLocation, File destinationFolder) throws IOException {
        Preconditions.checkArgument((programJarLocation != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)programJarLocation.exists());
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)destinationFolder.canWrite());
        destinationFolder.mkdirs();
        Preconditions.checkState((boolean)destinationFolder.exists());
        BundleJarUtil.unJar(new ZipInputStream(programJarLocation.getInputStream()), destinationFolder);
        return destinationFolder;
    }

    private static void unJar(ZipInputStream jarInputStream, File targetDirectory) throws IOException {
        ZipEntry entry;
        while ((entry = jarInputStream.getNextEntry()) != null) {
            File output = new File(targetDirectory, entry.getName());
            if (entry.isDirectory()) {
                output.mkdirs();
                continue;
            }
            output.getParentFile().mkdirs();
            ByteStreams.copy((InputStream)jarInputStream, (OutputSupplier)Files.newOutputStreamSupplier((File)output));
        }
    }

    private BundleJarUtil() {
    }
}

