/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.lang;

import co.cask.tigon.api.annotation.Property;
import co.cask.tigon.internal.lang.FieldVisitor;
import com.google.common.base.Throwables;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public final class PropertyFieldSetter
extends FieldVisitor {
    private final Map<String, String> properties;

    public PropertyFieldSetter(Map<String, String> properties) {
        this.properties = properties;
    }

    public void visit(Object instance, TypeToken<?> inspectType, TypeToken<?> declareType, Field field) throws Exception {
        if (field.isAnnotationPresent(Property.class)) {
            String key = declareType.getRawType().getName() + '.' + field.getName();
            String value = this.properties.get(key);
            if (value == null) {
                return;
            }
            this.setValue(instance, field, value);
        }
    }

    private void setValue(Object instance, Field field, String value) throws IllegalAccessException {
        Class fieldType;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (String.class.equals(fieldType = field.getType())) {
            field.set(instance, value);
            return;
        }
        if (fieldType.isEnum()) {
            field.set(instance, Enum.valueOf(fieldType, value));
            return;
        }
        if (fieldType.isPrimitive()) {
            fieldType = Primitives.wrap(fieldType);
        }
        try {
            field.set(instance, fieldType.getMethod("valueOf", String.class).invoke(null, value));
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

