/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.lang;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public class FilterClassLoader
extends ClassLoader {
    private final Predicate<String> resourceAcceptor;
    private final ClassLoader bootstrapClassLoader;

    public FilterClassLoader(Predicate<String> resourceAcceptor, ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.resourceAcceptor = resourceAcceptor;
        this.bootstrapClassLoader = new URLClassLoader(new URL[0], null);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.bootstrapClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.isValidResource(this.classNameToResourceName(name))) {
                return super.loadClass(name, resolve);
            }
            throw e;
        }
    }

    @Override
    public URL findResource(String name) {
        if (this.isValidResource(name)) {
            return super.findResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.isValidResource(name)) {
            return super.findResources(name);
        }
        return new CompoundEnumeration(new Enumeration[0]);
    }

    private String classNameToResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private boolean isValidResource(String resourceName) {
        return this.resourceAcceptor.apply((Object)resourceName);
    }
}

