/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.lang;

import co.cask.tigon.api.flow.Flow;
import co.cask.tigon.internal.guava.ClassPath;
import co.cask.tigon.lang.CombineClassLoader;
import co.cask.tigon.lang.FilterClassLoader;
import co.cask.tigon.lang.jar.ProgramClassLoader;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.twill.internal.utils.Dependencies;

public final class ClassLoaders {
    private static final List<String> HADOOP_PACKAGES = Lists.newArrayList((Object[])new String[]{"org.apache.hadoop"});
    private static final List<String> TIGON_API_PACKAGES = Lists.newArrayList((Object[])new String[]{"co.cask.tigon.api", "co.cask.tigon.internal"});
    private static final Predicate<URI> JAR_ONLY_URI = new Predicate<URI>(){

        public boolean apply(URI input) {
            return input.getPath().endsWith(".jar");
        }
    };

    private ClassLoaders() {
    }

    public static ProgramClassLoader newProgramClassLoader(File unpackedJarDir, Iterable<String> apiResourceList) throws IOException {
        Predicate predicate = Predicates.in((Collection)Sets.newHashSet(apiResourceList));
        ClassLoader filterParent = (ClassLoader)Objects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ClassLoaders.class.getClassLoader());
        return new ProgramClassLoader(unpackedJarDir, (ClassLoader)new FilterClassLoader((Predicate<String>)predicate, filterParent));
    }

    public static Iterable<String> getAPIResources(ClassLoader classLoader) throws IOException {
        HashSet bootstrapPaths = Sets.newHashSet();
        for (String classpath : Splitter.on((char)File.pathSeparatorChar).split((CharSequence)System.getProperty("sun.boot.class.path"))) {
            File file = new File(classpath);
            bootstrapPaths.add(file.getAbsolutePath());
            try {
                bootstrapPaths.add(file.getCanonicalPath());
            }
            catch (IOException e) {}
        }
        Set resources = ClassLoaders.getResources(classLoader, ClassLoaders.getAPIClassPath(), TIGON_API_PACKAGES, true, bootstrapPaths, Sets.newHashSet());
        return ClassLoaders.getResources(classLoader, ClassPath.from(classLoader, JAR_ONLY_URI), HADOOP_PACKAGES, false, bootstrapPaths, resources);
    }

    public static ClassLoader getClassLoader(TypeToken<?> type) {
        ClassLoader parent;
        Set classLoaders = Sets.newIdentityHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(type);
        while (!queue.isEmpty()) {
            type = (TypeToken)queue.remove();
            ClassLoader classLoader = type.getRawType().getClassLoader();
            if (classLoader != null) {
                classLoaders.add(classLoader);
            }
            if (!(type.getType() instanceof ParameterizedType)) continue;
            for (Type typeArg : ((ParameterizedType)type.getType()).getActualTypeArguments()) {
                queue.add(TypeToken.of((Type)typeArg));
            }
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = parent = contextClassLoader == null ? ClassLoader.getSystemClassLoader() : contextClassLoader;
        if (classLoaders.isEmpty()) {
            return parent;
        }
        return new CombineClassLoader(parent, classLoaders);
    }

    private static ClassPath getAPIClassPath() throws IOException {
        String resourceName;
        ClassLoader classLoader = Flow.class.getClassLoader();
        URL url = classLoader.getResource(resourceName = Flow.class.getName().replace('.', '/') + ".class");
        if (url == null) {
            throw new IOException("Resource not found for " + resourceName);
        }
        try {
            URI classPathURI = ClassLoaders.getClassPathURL(resourceName, url).toURI();
            return ClassPath.from(classPathURI, classLoader);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static URL getClassPathURL(String resourceName, URL resourceURL) {
        try {
            if ("file".equals(resourceURL.getProtocol())) {
                String path = resourceURL.getFile();
                int endIdx = path.length() - resourceName.length();
                if (endIdx > 1) {
                    --endIdx;
                }
                return new URL("file", "", -1, path.substring(0, endIdx));
            }
            if ("jar".equals(resourceURL.getProtocol())) {
                String path = resourceURL.getFile();
                return URI.create(path.substring(0, path.indexOf("!/"))).toURL();
            }
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        throw new IllegalStateException("Unsupported class URL: " + resourceURL);
    }

    private static <T extends Collection<String>> T getResources(ClassLoader classLoader, ClassPath classPath, Iterable<String> packages, boolean includeDependencies, final Set<String> bootstrapPaths, final T result) throws IOException {
        HashSet classes = Sets.newHashSet();
        for (String pkg : packages) {
            ImmutableSet<ClassPath.ClassInfo> packageClasses = classPath.getAllClassesRecursive(pkg);
            for (ClassPath.ClassInfo cls : packageClasses) {
                result.add((String)cls.getResourceName());
                classes.add(cls.getName());
            }
        }
        if (includeDependencies) {
            final HashSet classPathSeen = Sets.newHashSet();
            Dependencies.findClassDependencies((ClassLoader)classLoader, (Dependencies.ClassAcceptor)new Dependencies.ClassAcceptor(){

                public boolean accept(String className, URL classUrl, URL classPathUrl) {
                    if (bootstrapPaths.contains(classPathUrl.getFile())) {
                        return false;
                    }
                    if (!classPathSeen.add(classPathUrl)) {
                        return true;
                    }
                    try {
                        ClassPath classPath = ClassPath.from(classPathUrl.toURI(), ClassLoader.getSystemClassLoader());
                        for (ClassPath.ResourceInfo resourceInfo : classPath.getResources()) {
                            result.add(resourceInfo.getResourceName());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
            }, (Iterable)classes);
        }
        return result;
    }

    public static Class<?> loadClass(String className, @Nullable ClassLoader classLoader, Object caller) throws ClassNotFoundException {
        ClassLoader cl = (ClassLoader)Objects.firstNonNull((Object)classLoader, (Object)Objects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)caller.getClass().getClassLoader()));
        return cl.loadClass(className);
    }
}

