/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.io;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Seekable;

public abstract class SeekableInputStream
extends FilterInputStream
implements Seekable {
    public static SeekableInputStream create(InputStream input) throws IOException {
        if (input instanceof SeekableInputStream) {
            return (SeekableInputStream)input;
        }
        if (input instanceof FileInputStream) {
            return SeekableInputStream.create((FileInputStream)input);
        }
        if (input instanceof Seekable) {
            final Seekable seekable = (Seekable)input;
            return new SeekableInputStream(input){

                public void seek(long pos) throws IOException {
                    seekable.seek(pos);
                }

                public long getPos() throws IOException {
                    return seekable.getPos();
                }

                public boolean seekToNewSource(long targetPos) throws IOException {
                    return seekable.seekToNewSource(targetPos);
                }
            };
        }
        throw new IOException("Failed to create SeekableInputStream from " + input.getClass());
    }

    private static SeekableInputStream create(final FileInputStream input) {
        return new SeekableInputStream(input){

            public void seek(long pos) throws IOException {
                input.getChannel().position(pos);
            }

            public long getPos() throws IOException {
                return input.getChannel().position();
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }
        };
    }

    protected SeekableInputStream(InputStream in) {
        super(in);
    }
}

