/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.io;

import co.cask.tigon.io.SeekableInputStream;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.twill.filesystem.Location;

public final class Locations {
    public static final Comparator<Location> LOCATION_COMPARATOR = new Comparator<Location>(){

        @Override
        public int compare(Location o1, Location o2) {
            return o1.toURI().compareTo(o2.toURI());
        }
    };

    public static InputSupplier<? extends SeekableInputStream> newInputSupplier(final FileSystem fs, final Path path) {
        return new InputSupplier<SeekableInputStream>(){

            public SeekableInputStream getInput() throws IOException {
                return SeekableInputStream.create((InputStream)fs.open(path));
            }
        };
    }

    public static InputSupplier<? extends SeekableInputStream> newInputSupplier(final Location location) {
        return new InputSupplier<SeekableInputStream>(){

            public SeekableInputStream getInput() throws IOException {
                return SeekableInputStream.create(location.getInputStream());
            }
        };
    }

    public static OutputSupplier<? extends OutputStream> newOutputSupplier(final Location location) {
        return new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return location.getOutputStream();
            }
        };
    }

    @Nullable
    public static Location getParent(Location location) {
        URI source = location.toURI();
        if ("/".equals(source.getPath())) {
            return null;
        }
        URI resolvedParent = URI.create(source.toString() + "/..").normalize();
        return location.getLocationFactory().create(resolvedParent);
    }

    public static void mkdirsIfNotExists(Location location) throws IOException {
        if (!(location.isDirectory() || location.mkdirs() || location.isDirectory())) {
            throw new IOException("Failed to create directory at " + location.toURI());
        }
    }

    private Locations() {
    }
}

