/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.internal.io;

import co.cask.tigon.internal.asm.ByteCodeClassLoader;
import co.cask.tigon.internal.asm.ClassDefinition;
import co.cask.tigon.internal.io.DatumWriter;
import co.cask.tigon.internal.io.DatumWriterFactory;
import co.cask.tigon.internal.io.DatumWriterGenerator;
import co.cask.tigon.internal.io.FieldAccessorFactory;
import co.cask.tigon.internal.io.Schema;
import co.cask.tigon.lang.ClassLoaders;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ASMDatumWriterFactory
implements DatumWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ASMDatumWriterFactory.class);
    private final LoadingCache<CacheKey, Class<DatumWriter<?>>> datumWriterClasses;
    private final FieldAccessorFactory fieldAccessorFactory;

    @Inject
    public ASMDatumWriterFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
        this.datumWriterClasses = CacheBuilder.newBuilder().build((CacheLoader)new ASMCacheLoader());
    }

    public <T> DatumWriter<T> create(TypeToken<T> type, Schema schema) {
        try {
            Class writerClass = (Class)this.datumWriterClasses.getUnchecked((Object)new CacheKey(schema, type));
            return (DatumWriter)writerClass.getConstructor(Schema.class, FieldAccessorFactory.class).newInstance(schema, this.fieldAccessorFactory);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static final class CacheKey {
        private final Schema schema;
        private final TypeToken<?> type;

        private CacheKey(Schema schema, TypeToken<?> type) {
            this.schema = schema;
            this.type = type;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public TypeToken<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.schema.equals((Object)cacheKey.schema) && this.type.equals(cacheKey.type);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.schema, this.type});
        }
    }

    private static final class ASMCacheLoader
    extends CacheLoader<CacheKey, Class<DatumWriter<?>>> {
        private final Map<TypeToken<?>, ByteCodeClassLoader> classloaders = Maps.newIdentityHashMap();

        private ASMCacheLoader() {
        }

        public Class<DatumWriter<?>> load(CacheKey key) throws Exception {
            ClassDefinition classDef = new DatumWriterGenerator().generate(key.getType(), key.getSchema());
            ClassLoader typeClassloader = ClassLoaders.getClassLoader(key.getType());
            ByteCodeClassLoader classloader = this.classloaders.get(key.getType());
            if (classloader == null) {
                classloader = new ByteCodeClassLoader(typeClassloader);
                this.classloaders.put(key.getType(), classloader);
            }
            return classloader.addClass(classDef, key.getType().getRawType()).loadClass(classDef.getClassName());
        }
    }
}

