/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.internal.guava;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.Reflection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ClassPath {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPath.class);
    private static final Predicate<ClassInfo> IS_TOP_LEVEL = new Predicate<ClassInfo>(){

        public boolean apply(ClassInfo info) {
            return info.className.indexOf(36) == -1;
        }
    };
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on((String)" ").omitEmptyStrings();
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final ImmutableSet<ResourceInfo> resources;

    private ClassPath(ImmutableSet<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        return ClassPath.from(classloader, (Predicate<URI>)Predicates.alwaysTrue());
    }

    public static ClassPath from(ClassLoader classloader, Predicate<URI> predicate) throws IOException {
        Scanner scanner = new Scanner();
        for (Map.Entry entry : ClassPath.getClassPathEntries(classloader, predicate).entrySet()) {
            scanner.scan((URI)entry.getKey(), (ClassLoader)entry.getValue());
        }
        return new ClassPath((ImmutableSet<ResourceInfo>)scanner.getResources());
    }

    public static ClassPath from(URI uri, ClassLoader classLoader) throws IOException {
        Scanner scanner = new Scanner();
        scanner.scan(uri, classLoader);
        return new ClassPath((ImmutableSet<ResourceInfo>)scanner.getResources());
    }

    public ImmutableSet<ResourceInfo> getResources() {
        return this.resources;
    }

    public ImmutableSet<ClassInfo> getAllClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).toImmutableSet();
    }

    public ImmutableSet<ClassInfo> getAllClassesRecursive(String packageName) {
        Preconditions.checkNotNull((Object)packageName);
        String packagePrefix = packageName + '.';
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<ClassInfo> allClasses = this.getAllClasses();
        LinkedList debugData = Lists.newLinkedList();
        for (ClassInfo classInfo : allClasses) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add((Object)classInfo);
            debugData.add(classInfo.getResourceName() + "\n");
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).filter(IS_TOP_LEVEL).toImmutableSet();
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses(String packageName) {
        Preconditions.checkNotNull((Object)packageName);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            builder.add((Object)classInfo);
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        Preconditions.checkNotNull((Object)packageName);
        String packagePrefix = packageName + '.';
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<ClassInfo> topLevelClasses = this.getTopLevelClasses();
        LinkedList debugData = Lists.newLinkedList();
        for (ClassInfo classInfo : topLevelClasses) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add((Object)classInfo);
            debugData.add(classInfo.getResourceName() + "\n");
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableMap<URI, ClassLoader> getClassPathEntries(ClassLoader classloader, Predicate<URI> predicate) {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(ClassPath.getClassPathEntries(parent, predicate));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry : urlClassLoader.getURLs()) {
                URI uri;
                try {
                    uri = entry.toURI();
                    if (!predicate.apply((Object)uri)) {
                        continue;
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                if (entries.containsKey(uri)) continue;
                entries.put(uri, classloader);
            }
        }
        return ImmutableMap.copyOf((Map)entries);
    }

    @VisibleForTesting
    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    @VisibleForTesting
    static final class Scanner {
        private final ImmutableSortedSet.Builder<ResourceInfo> resources = new ImmutableSortedSet.Builder((Comparator)Ordering.usingToString());
        private final Set<URI> scannedUris = Sets.newHashSet();

        Scanner() {
        }

        ImmutableSortedSet<ResourceInfo> getResources() {
            return this.resources.build();
        }

        void scan(URI uri, ClassLoader classloader) throws IOException {
            if (uri.getScheme().equals("file") && this.scannedUris.add(uri)) {
                this.scanFrom(new File(uri), classloader);
            }
        }

        @VisibleForTesting
        void scanFrom(File file, ClassLoader classloader) throws IOException {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, classloader);
            } else {
                this.scanJar(file, classloader);
            }
        }

        private void scanDirectory(File directory, ClassLoader classloader) throws IOException {
            this.scanDirectory(directory, classloader, "", (ImmutableSet<File>)ImmutableSet.of());
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, ImmutableSet<File> ancestors) throws IOException {
            File canonical = directory.getCanonicalFile();
            if (ancestors.contains((Object)canonical)) {
                return;
            }
            File[] files = directory.listFiles();
            if (files == null) {
                LOG.warn("Cannot read directory " + directory);
                return;
            }
            ImmutableSet newAncestors = ImmutableSet.builder().addAll(ancestors).add((Object)canonical).build();
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    this.scanDirectory(f, classloader, packagePrefix + name + "/", (ImmutableSet<File>)newAncestors);
                    continue;
                }
                String resourceName = packagePrefix + name;
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                this.resources.add((Object)ResourceInfo.of(resourceName, classloader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                for (URI uri : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(uri, classloader);
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    this.resources.add((Object)ResourceInfo.of(entry.getName(), classloader));
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }

        @VisibleForTesting
        static ImmutableSet<URI> getClassPathFromManifest(File jarFile, @Nullable Manifest manifest) {
            if (manifest == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)classpathAttribute)) {
                    URI uri;
                    try {
                        uri = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (URISyntaxException e) {
                        LOG.warn("Invalid Class-Path entry: " + path);
                        continue;
                    }
                    builder.add((Object)uri);
                }
            }
            return builder.build();
        }

        @VisibleForTesting
        static URI getClassPathEntry(File jarFile, String path) throws URISyntaxException {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return uri;
            }
            return new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI();
        }
    }

    @Beta
    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            return Reflection.getPackageName((String)this.className);
        }

        public String getSimpleName() {
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                String innerClassName = this.className.substring(lastDollarSign + 1);
                return CharMatcher.DIGIT.trimLeadingFrom((CharSequence)innerClassName);
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    @Beta
    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(resourceName, loader);
            }
            return new ResourceInfo(resourceName, loader);
        }

        ResourceInfo(String resourceName, ClassLoader loader) {
            this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName);
            this.loader = (ClassLoader)Preconditions.checkNotNull((Object)loader);
        }

        public final URL url() {
            return (URL)Preconditions.checkNotNull((Object)this.loader.getResource(this.resourceName), (String)"Failed to load resource: %s", (Object[])new Object[]{this.resourceName});
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

