/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.internal.asm;

import co.cask.tigon.internal.asm.ClassDefinition;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class ByteCodeClassLoader
extends ClassLoader {
    protected final Map<String, byte[]> bytecodes = Maps.newHashMap();
    protected final Map<String, Class<?>> typeClasses = Maps.newHashMap();

    public ByteCodeClassLoader(ClassLoader parent) {
        super(parent);
    }

    public final synchronized ByteCodeClassLoader addClass(ClassDefinition classDef, @Nullable Class<?> typeClass) {
        this.bytecodes.put(classDef.getClassName(), classDef.getBytecode());
        if (typeClass != null) {
            this.typeClasses.put(typeClass.getName(), typeClass);
        }
        return this;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            return result;
        }
        result = this.typeClasses.get(className);
        if (result != null) {
            return result;
        }
        byte[] bytecode = this.bytecodes.get(className);
        if (bytecode != null) {
            result = this.defineClass(className, bytecode, 0, bytecode.length);
            if (resolveIt) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(className, resolveIt);
    }
}

