/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.guice;

import co.cask.tigon.conf.CConfiguration;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.twill.api.TwillRunner;
import org.apache.twill.api.TwillRunnerService;
import org.apache.twill.filesystem.LocationFactories;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.yarn.YarnTwillRunnerService;

public class TwillModule
extends PrivateModule {
    protected void configure() {
        this.bind(TwillRunnerService.class).to(YarnTwillRunnerService.class).in(Scopes.SINGLETON);
        this.bind(TwillRunner.class).to(TwillRunnerService.class);
        this.expose(TwillRunnerService.class);
        this.expose(TwillRunner.class);
    }

    @Singleton
    @Provides
    private YarnTwillRunnerService provideYarnTwillRunnerService(CConfiguration configuration, YarnConfiguration yarnConfiguration, LocationFactory locationFactory) {
        String zkConnectStr = configuration.get("zookeeper.quorum") + configuration.get("twill.zookeeper.namespace");
        YarnConfiguration yarnConfig = new YarnConfiguration((Configuration)yarnConfiguration);
        yarnConfig.set("twill.java.reserved.memory.mb", configuration.get("twill.java.reserved.memory.mb"));
        YarnTwillRunnerService runner = new YarnTwillRunnerService(yarnConfig, zkConnectStr, LocationFactories.namespace((LocationFactory)locationFactory, (String)"twill"));
        runner.setJVMOptions(configuration.get("app.program.jvm.opts"));
        return runner;
    }
}

