/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.guice;

import co.cask.tigon.conf.CConfiguration;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.concurrent.TimeUnit;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ServiceDiscovered;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProgramDiscoveryServiceClient
implements DiscoveryServiceClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProgramDiscoveryServiceClient.class);
    private static final long CACHE_EXPIRES_MINUTES = 1L;
    private final ZKClient zkClient;
    private final DiscoveryServiceClient delegate;
    private final String twillNamespace;
    private final LoadingCache<String, DiscoveryServiceClient> clients;

    @Inject
    ProgramDiscoveryServiceClient(ZKClient zkClient, CConfiguration configuration, @Named(value="local.discovery.client") DiscoveryServiceClient delegate) {
        this.zkClient = zkClient;
        this.delegate = delegate;
        this.twillNamespace = configuration.get("twill.zookeeper.namespace");
        this.clients = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(this.createClientLoader());
    }

    public ServiceDiscovered discover(String name) {
        for (DiscoverableProgramType type : DiscoverableProgramType.values()) {
            if (!type.isPrefixOf(name)) continue;
            return ((DiscoveryServiceClient)this.clients.getUnchecked((Object)name)).discover(name);
        }
        return this.delegate.discover(name);
    }

    private CacheLoader<String, DiscoveryServiceClient> createClientLoader() {
        return new CacheLoader<String, DiscoveryServiceClient>(){

            public DiscoveryServiceClient load(String key) throws Exception {
                int idx = key.indexOf(46);
                String ns = String.format("%s/%s%s", ProgramDiscoveryServiceClient.this.twillNamespace, key.substring(0, idx), key.substring(idx));
                LOG.debug("Create ZKDiscoveryClient for " + ns);
                return new ZKDiscoveryService(ZKClients.namespace((ZKClient)ProgramDiscoveryServiceClient.this.zkClient, (String)ns));
            }
        };
    }

    private static enum DiscoverableProgramType {
        PROCEDURE,
        WORKFLOW,
        WEBAPP,
        SERVICE;

        private final String prefix = this.name().toLowerCase() + ".";

        boolean isPrefixOf(String name) {
            return name.startsWith(this.prefix);
        }
    }
}

