/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.guice;

import co.cask.tigon.conf.CConfiguration;
import co.cask.tigon.runtime.RuntimeModule;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.twill.filesystem.HDFSLocationFactory;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.LocationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocationRuntimeModule
extends RuntimeModule {
    private static final Logger LOG = LoggerFactory.getLogger(LocationRuntimeModule.class);

    public Module getInMemoryModules() {
        return new LocalLocationModule();
    }

    public Module getSingleNodeModules() {
        return new LocalLocationModule();
    }

    public Module getDistributedModules() {
        return new HDFSLocationModule();
    }

    private static final class HDFSLocationModule
    extends AbstractModule {
        private HDFSLocationModule() {
        }

        protected void configure() {
            this.bind(LocationFactory.class).to(HDFSLocationFactory.class);
        }

        @Provides
        @Singleton
        private HDFSLocationFactory providesHDFSLocationFactory(CConfiguration cConf, Configuration hConf) {
            String hdfsUser = cConf.get("hdfs.user");
            String namespace = cConf.get("hdfs.namespace");
            LOG.info("HDFS namespace is " + namespace);
            try {
                FileSystem fileSystem;
                if (hdfsUser == null || UserGroupInformation.isSecurityEnabled()) {
                    if (hdfsUser != null && LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring configuration {}={}, running on secure Hadoop", (Object)"hdfs.user", (Object)hdfsUser);
                    }
                    fileSystem = FileSystem.get((URI)FileSystem.getDefaultUri((Configuration)hConf), (Configuration)hConf);
                } else {
                    fileSystem = FileSystem.get((URI)FileSystem.getDefaultUri((Configuration)hConf), (Configuration)hConf, (String)hdfsUser);
                }
                return new HDFSLocationFactory(fileSystem, namespace);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LocalLocationModule
    extends AbstractModule {
        private LocalLocationModule() {
        }

        protected void configure() {
            this.bind(LocationFactory.class).to(LocalLocationFactory.class);
        }

        @Provides
        @Singleton
        private LocalLocationFactory providesLocalLocationFactory(CConfiguration cConf) {
            return new LocalLocationFactory(new File(cConf.get("local.data.dir")));
        }
    }
}

