/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.conf;

import co.cask.tigon.conf.Configurable;
import co.cask.tigon.conf.Configuration;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();

    private static void setConf(Object theObject, Configuration conf) {
        if (conf != null && theObject instanceof Configurable) {
            ((Configurable)theObject).setConf(conf);
        }
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result, conf);
        return (T)result;
    }

    public static <T> Class<T> getClass(T o) {
        return o.getClass();
    }

    static void clearCache() {
        CONSTRUCTOR_CACHE.clear();
    }

    static int getCacheSize() {
        return CONSTRUCTOR_CACHE.size();
    }
}

