/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.test;

import co.cask.tigon.internal.app.runtime.ProgramController;
import co.cask.tigon.test.FlowManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.twill.discovery.ServiceDiscovered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowManager
implements FlowManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFlowManager.class);
    private final ProgramController controller;

    public DefaultFlowManager(ProgramController controller) {
        this.controller = controller;
    }

    @Override
    public void setFlowletInstances(String flowletName, int instances) {
        HashMap instanceOptions = Maps.newHashMap();
        instanceOptions.put("flowlet", flowletName);
        instanceOptions.put("newInstances", String.valueOf(instances));
        this.controller.command("flowletInstances", (Object)instanceOptions);
    }

    @Override
    public void stop() {
        try {
            this.controller.stop().get();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ServiceDiscovered discover(String service) {
        return this.controller.discover(service);
    }
}

