/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon.test;

import co.cask.tephra.TransactionManager;
import co.cask.tigon.api.flow.Flow;
import co.cask.tigon.app.guice.ProgramRunnerRuntimeModule;
import co.cask.tigon.conf.CConfiguration;
import co.cask.tigon.data.runtime.DataFabricInMemoryModule;
import co.cask.tigon.flow.DeployClient;
import co.cask.tigon.guice.ConfigModule;
import co.cask.tigon.guice.DiscoveryRuntimeModule;
import co.cask.tigon.guice.IOModule;
import co.cask.tigon.guice.LocationRuntimeModule;
import co.cask.tigon.internal.app.runtime.ProgramController;
import co.cask.tigon.metrics.MetricsCollectionService;
import co.cask.tigon.metrics.NoOpMetricsCollectionService;
import co.cask.tigon.test.DefaultFlowManager;
import co.cask.tigon.test.FlowManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.File;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.filesystem.Location;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class TestBase {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();
    private static MetricsCollectionService metricsCollectionService;
    private static TransactionManager txService;
    private static DeployClient deployClient;

    protected static FlowManager deployFlow(Class<? extends Flow> flowClz, Map<String, String> runtimeArgs, File ... bundleEmbeddedJars) {
        Preconditions.checkNotNull(flowClz, (Object)"Flow class cannot be null");
        try {
            Location deployJar = deployClient.jarForTestBase(flowClz, bundleEmbeddedJars);
            ProgramController controller = deployClient.startFlow(new File(deployJar.toURI()), flowClz.getName(), tmpFolder.newFolder(), runtimeArgs);
            return new DefaultFlowManager(controller);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @BeforeClass
    public static void init() throws Exception {
        File localDataDir = tmpFolder.newFolder();
        CConfiguration cConf = CConfiguration.create();
        cConf.set("local.data.dir", localDataDir.getAbsolutePath());
        Configuration hConf = new Configuration();
        Injector injector = Guice.createInjector((Module[])new Module[]{new DataFabricInMemoryModule(), new ConfigModule(cConf, hConf), new IOModule(), new LocationRuntimeModule().getInMemoryModules(), new DiscoveryRuntimeModule().getInMemoryModules(), new ProgramRunnerRuntimeModule().getInMemoryModules(), new TestMetricsClientModule()});
        txService = (TransactionManager)injector.getInstance(TransactionManager.class);
        txService.startAndWait();
        metricsCollectionService = (MetricsCollectionService)injector.getInstance(MetricsCollectionService.class);
        metricsCollectionService.startAndWait();
        deployClient = (DeployClient)injector.getInstance(DeployClient.class);
    }

    @AfterClass
    public static void finish() {
        metricsCollectionService.stopAndWait();
        txService.stopAndWait();
    }

    private static final class TestMetricsClientModule
    extends AbstractModule {
        private TestMetricsClientModule() {
        }

        protected void configure() {
            this.bind(MetricsCollectionService.class).to(NoOpMetricsCollectionService.class).in(Scopes.SINGLETON);
        }
    }
}

