/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon;

import co.cask.tephra.TransactionManager;
import co.cask.tigon.app.guice.ProgramRunnerRuntimeModule;
import co.cask.tigon.conf.CConfiguration;
import co.cask.tigon.data.runtime.DataFabricInMemoryModule;
import co.cask.tigon.flow.DeployClient;
import co.cask.tigon.guice.ConfigModule;
import co.cask.tigon.guice.DiscoveryRuntimeModule;
import co.cask.tigon.guice.IOModule;
import co.cask.tigon.guice.LocationRuntimeModule;
import co.cask.tigon.internal.app.runtime.ProgramController;
import co.cask.tigon.metrics.MetricsCollectionService;
import co.cask.tigon.metrics.NoOpMetricsCollectionService;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneMain {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneMain.class);
    private final CountDownLatch runLatch = new CountDownLatch(1);
    private final File jarUnpackDir = Files.createTempDir();
    private final File localDataDir = Files.createTempDir();
    private final MetricsCollectionService metricsCollectionService;
    private final TransactionManager txService;
    private final DeployClient deployClient;
    private ProgramController controller;

    public StandaloneMain() {
        CConfiguration cConf = CConfiguration.create();
        cConf.set("local.data.dir", this.localDataDir.getAbsolutePath());
        Configuration hConf = new Configuration();
        Injector injector = Guice.createInjector(StandaloneMain.createModules(cConf, hConf));
        this.txService = (TransactionManager)injector.getInstance(TransactionManager.class);
        this.metricsCollectionService = (MetricsCollectionService)injector.getInstance(MetricsCollectionService.class);
        this.deployClient = (DeployClient)injector.getInstance(DeployClient.class);
    }

    private static void usage(boolean error) {
        PrintStream out = error ? System.err : System.out;
        out.println("java -cp .:lib/* co.cask.tigon.StandaloneMain <path-to-JAR> <FlowClassName> [arguments]");
        out.println("Example: java -cp .:lib/* co.cask.tigon.StandaloneMain /home/user/tweetFlow-1.0.jar com.cname.main.TweetFlow --runtimeKey=value");
        out.println("");
        if (error) {
            throw new IllegalArgumentException();
        }
    }

    public static StandaloneMain createStandaloneMain() {
        return new StandaloneMain();
    }

    public static void main(String[] args) {
        System.out.println("Tigon Standalone Client");
        if (args.length > 0) {
            if ("--help".equals(args[0]) || "-h".equals(args[0])) {
                StandaloneMain.usage(false);
                return;
            }
            if (args.length < 2) {
                StandaloneMain.usage(true);
            }
            File jarPath = new File(args[0]);
            String mainClassName = args[1];
            Map runtimeArgs = null;
            try {
                runtimeArgs = DeployClient.fromPosixArray((String[])Arrays.copyOfRange(args, 2, args.length));
            }
            catch (IllegalArgumentException e) {
                StandaloneMain.usage(true);
            }
            try {
                StandaloneMain main = StandaloneMain.createStandaloneMain();
                main.startUp(jarPath, mainClassName, runtimeArgs);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void startUp(File jarPath, String mainClassName, Map<String, String> runtimeArgs) throws Exception {
        this.txService.startAndWait();
        this.metricsCollectionService.startAndWait();
        this.addShutDownHook();
        this.controller = this.deployClient.startFlow(jarPath, mainClassName, this.jarUnpackDir, runtimeArgs);
        this.runLatch.await();
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    StandaloneMain.this.shutDown();
                }
                catch (Throwable e) {
                    LOG.error("Failed to shutdown", e);
                }
            }
        });
    }

    public void shutDown() {
        try {
            if (this.controller != null) {
                this.controller.stop().get();
            }
            this.metricsCollectionService.stopAndWait();
            this.txService.stopAndWait();
            FileUtils.deleteDirectory((File)this.localDataDir);
            FileUtils.deleteDirectory((File)this.jarUnpackDir);
            this.runLatch.countDown();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static List<Module> createModules(CConfiguration cConf, Configuration hConf) {
        return ImmutableList.of((Object)new DataFabricInMemoryModule(), (Object)new ConfigModule(cConf, hConf), (Object)new IOModule(), (Object)new LocationRuntimeModule().getInMemoryModules(), (Object)new DiscoveryRuntimeModule().getInMemoryModules(), (Object)new ProgramRunnerRuntimeModule().getInMemoryModules(), (Object)((Object)new MetricsClientModule()));
    }

    private static final class MetricsClientModule
    extends AbstractModule {
        private MetricsClientModule() {
        }

        protected void configure() {
            this.bind(MetricsCollectionService.class).to(NoOpMetricsCollectionService.class).in(Scopes.SINGLETON);
        }
    }
}

