/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tigon;

import co.cask.tigon.app.guice.ProgramRunnerRuntimeModule;
import co.cask.tigon.cli.CLICommands;
import co.cask.tigon.cli.DistributedFlowOperations;
import co.cask.tigon.cli.FlowOperations;
import co.cask.tigon.cli.InvalidCLIArgumentException;
import co.cask.tigon.conf.CConfiguration;
import co.cask.tigon.data.runtime.DataFabricDistributedModule;
import co.cask.tigon.flow.DeployClient;
import co.cask.tigon.guice.ConfigModule;
import co.cask.tigon.guice.DiscoveryRuntimeModule;
import co.cask.tigon.guice.IOModule;
import co.cask.tigon.guice.LocationRuntimeModule;
import co.cask.tigon.guice.TwillModule;
import co.cask.tigon.guice.ZKClientModule;
import co.cask.tigon.metrics.MetricsCollectionService;
import co.cask.tigon.metrics.NoOpMetricsCollectionService;
import co.cask.tigon.utils.ProjectInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMain {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedMain.class);
    private final File localDataDir = Files.createTempDir();
    private final FlowOperations flowOperations;
    private final ConsoleReader consoleReader;

    public DistributedMain(String zkQuorumString, String rootNamespace) throws IOException {
        CConfiguration cConf = CConfiguration.create();
        cConf.set("zookeeper.quorum", zkQuorumString);
        cConf.set("root.namespace", rootNamespace);
        cConf.set("local.data.dir", this.localDataDir.getAbsolutePath());
        cConf.reloadConfiguration();
        Configuration hConf = HBaseConfiguration.create();
        Injector injector = Guice.createInjector(DistributedMain.createModules(cConf, hConf));
        this.flowOperations = (FlowOperations)injector.getInstance(FlowOperations.class);
        this.consoleReader = new ConsoleReader();
    }

    private static void usage(boolean error) {
        PrintStream out = error ? System.err : System.out;
        out.println("Usage:   java -cp lib/*:<hadoop/hbase classpath> co.cask.tigon.DistributedMain <ZooKeeperQuorum> <HDFSNamespace>");
        out.println("Example: java -cp lib/*:$HBASE_CLASSPATH co.cask.tigon.DistributedMain 165.238.239.12:1234/tigon tigon");
        out.println("");
        if (error) {
            throw new IllegalArgumentException();
        }
    }

    public static DistributedMain createDistributedMain(String zkString, String rootNamespace) throws IOException {
        return new DistributedMain(zkString, rootNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("Tigon Distributed Client");
        if (args.length > 0) {
            if ("--help".equals(args[0]) || "-h".equals(args[0])) {
                DistributedMain.usage(false);
                return;
            }
            if (args.length < 2) {
                DistributedMain.usage(true);
            }
            String zkQuorumString = args[0];
            String rootNamespace = args[1];
            DistributedMain main = null;
            try {
                main = DistributedMain.createDistributedMain(zkQuorumString, rootNamespace);
                main.startUp(System.out);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (main != null) {
                        main.shutDown();
                    }
                    TerminalFactory.get().restore();
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void registerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    DistributedMain.this.shutDown();
                }
                catch (Throwable e) {
                    LOG.error("Failed to shutdown", e);
                }
            }
        });
    }

    public void startUp(PrintStream out) throws Exception {
        String line;
        this.registerShutDownHook();
        this.flowOperations.startAndWait();
        ArrayList commandList = Lists.newArrayList();
        for (CLICommands cliCommand : CLICommands.values()) {
            commandList.add(cliCommand.toString().toLowerCase());
        }
        this.consoleReader.setPrompt("tigon> ");
        while ((line = this.consoleReader.readLine()) != null) {
            String[] args = line.split("\\s+");
            String command = args[0].toUpperCase();
            try {
                CLICommands cmd = null;
                try {
                    cmd = CLICommands.valueOf(command);
                }
                catch (IllegalArgumentException e) {
                    out.println("Available Commands : ");
                    out.println(StringUtils.join((Collection)commandList, (String)", "));
                    continue;
                }
                if (args.length < cmd.getArgCount()) {
                    throw new InvalidCLIArgumentException(cmd.printHelp());
                }
                if (cmd.equals((Object)CLICommands.START)) {
                    Map runtimeArgs = Maps.newHashMap();
                    if (args.length > cmd.getArgCount()) {
                        try {
                            runtimeArgs = DeployClient.fromPosixArray((String[])Arrays.copyOfRange(args, cmd.getArgCount(), args.length));
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error("Runtime Args are not in the correct format [ --key1=val1 --key2=val2 ]");
                            continue;
                        }
                    }
                    this.flowOperations.startFlow(new File(args[1]), args[2], runtimeArgs);
                    continue;
                }
                if (cmd.equals((Object)CLICommands.LIST)) {
                    out.println(StringUtils.join(this.flowOperations.listAllFlows(), (String)", "));
                    continue;
                }
                if (cmd.equals((Object)CLICommands.STOP)) {
                    this.flowOperations.stopFlow(args[1]);
                    continue;
                }
                if (cmd.equals((Object)CLICommands.DELETE)) {
                    this.flowOperations.deleteFlow(args[1]);
                    continue;
                }
                if (cmd.equals((Object)CLICommands.SET)) {
                    this.flowOperations.setInstances(args[1], args[2], Integer.valueOf(args[3]));
                    continue;
                }
                if (cmd.equals((Object)CLICommands.STATUS)) {
                    Service.State state = this.flowOperations.getStatus(args[1]);
                    String status = state != null ? state.toString() : "NOT FOUND";
                    out.println(status);
                    continue;
                }
                if (cmd.equals((Object)CLICommands.FLOWLETINFO)) {
                    out.println(String.format("%-20s %s", "Flowlet Name", "Instance Count"));
                    Map<String, Integer> flowletInfoMap = this.flowOperations.getFlowInfo(args[1]);
                    for (Map.Entry<String, Integer> flowletInfo : flowletInfoMap.entrySet()) {
                        out.println(String.format("%-20s %s", flowletInfo.getKey(), flowletInfo.getValue()));
                    }
                    continue;
                }
                if (cmd.equals((Object)CLICommands.DISCOVER)) {
                    for (InetSocketAddress socketAddress : this.flowOperations.discover(args[1], args[2])) {
                        out.println(String.format("%s:%s", socketAddress.getHostName(), socketAddress.getPort()));
                    }
                    continue;
                }
                if (cmd.equals((Object)CLICommands.SHOWLOGS)) {
                    this.flowOperations.addLogHandler(args[1], System.out);
                    continue;
                }
                if (cmd.equals((Object)CLICommands.SERVICEINFO)) {
                    out.println(StringUtils.join(this.flowOperations.getServices(args[1]), (String)"\n"));
                    continue;
                }
                if (cmd.equals((Object)CLICommands.VERSION)) {
                    out.println(ProjectInfo.getVersion().getBuildVersion());
                    continue;
                }
                if (!cmd.equals((Object)CLICommands.HELP)) break;
                try {
                    out.println(CLICommands.valueOf(args[1].toUpperCase()).printHelp());
                }
                catch (IllegalArgumentException e) {
                    out.println("Command Not Found");
                }
            }
            catch (InvalidCLIArgumentException e) {
                out.println(e.getMessage());
            }
        }
    }

    public void shutDown() {
        try {
            this.flowOperations.stopAndWait();
            FileUtils.deleteDirectory((File)this.localDataDir);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static List<Module> createModules(CConfiguration cConf, Configuration hConf) {
        return ImmutableList.of((Object)new DataFabricDistributedModule(), (Object)new ConfigModule(cConf, hConf), (Object)new IOModule(), (Object)new ZKClientModule(), (Object)new TwillModule(), (Object)new LocationRuntimeModule().getDistributedModules(), (Object)new DiscoveryRuntimeModule().getDistributedModules(), (Object)new ProgramRunnerRuntimeModule().getDistributedModules(), (Object)((Object)new MetricsClientModule()), (Object)new AbstractModule(){

            protected void configure() {
                this.bind(FlowOperations.class).to(DistributedFlowOperations.class);
            }
        });
    }

    private static final class MetricsClientModule
    extends AbstractModule {
        private MetricsClientModule() {
        }

        protected void configure() {
            this.bind(MetricsCollectionService.class).to(NoOpMetricsCollectionService.class).in(Scopes.SINGLETON);
        }
    }
}

