/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionType;
import co.cask.tephra.persist.TransactionEdit;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public final class TransactionEditUtil {
    private static Random random = new Random();

    public static List<TransactionEdit> createRandomEdits(int numEntries) {
        ArrayList edits = Lists.newArrayListWithCapacity((int)numEntries);
        block8: for (int i = 0; i < numEntries; ++i) {
            TransactionEdit.State nextType = TransactionEdit.State.values()[random.nextInt(6)];
            long writePointer = Math.abs(random.nextLong());
            switch (nextType) {
                case INPROGRESS: {
                    edits.add(TransactionEdit.createStarted((long)writePointer, (long)(writePointer - 1L), (long)(System.currentTimeMillis() + 300000L), (TransactionType)TransactionType.SHORT));
                    continue block8;
                }
                case COMMITTING: {
                    edits.add(TransactionEdit.createCommitting((long)writePointer, TransactionEditUtil.generateChangeSet(10)));
                    continue block8;
                }
                case COMMITTED: {
                    edits.add(TransactionEdit.createCommitted((long)writePointer, TransactionEditUtil.generateChangeSet(10), (long)(writePointer + 1L), (boolean)random.nextBoolean()));
                    continue block8;
                }
                case INVALID: {
                    edits.add(TransactionEdit.createInvalid((long)writePointer));
                    continue block8;
                }
                case ABORTED: {
                    edits.add(TransactionEdit.createAborted((long)writePointer, (TransactionType)TransactionType.SHORT, null));
                    continue block8;
                }
                case MOVE_WATERMARK: {
                    edits.add(TransactionEdit.createMoveWatermark((long)writePointer));
                }
            }
        }
        return edits;
    }

    private static Set<ChangeId> generateChangeSet(int numEntries) {
        HashSet changes = Sets.newHashSet();
        for (int i = 0; i < numEntries; ++i) {
            byte[] bytes = new byte[8];
            random.nextBytes(bytes);
            changes.add(new ChangeId(bytes));
        }
        return changes;
    }
}

