/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import co.cask.tephra.util.HBaseVersion;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class HBaseVersionTest {
    @Test
    public void testVersionNumber() throws Exception {
        HBaseVersion.VersionNumber ver = HBaseVersion.VersionNumber.create((String)"1");
        this.assertVersionNumber(ver, 1, null, null, null, false);
        ver = HBaseVersion.VersionNumber.create((String)"1-SNAPSHOT");
        this.assertVersionNumber(ver, 1, null, null, null, true);
        ver = HBaseVersion.VersionNumber.create((String)"1-foo");
        this.assertVersionNumber(ver, 1, null, null, "foo", false);
        ver = HBaseVersion.VersionNumber.create((String)"1-foo-SNAPSHOT");
        this.assertVersionNumber(ver, 1, null, null, "foo", true);
        ver = HBaseVersion.VersionNumber.create((String)"10.0");
        this.assertVersionNumber(ver, 10, 0, null, null, false);
        ver = HBaseVersion.VersionNumber.create((String)"10.0-bar");
        this.assertVersionNumber(ver, 10, 0, null, "bar", false);
        ver = HBaseVersion.VersionNumber.create((String)"3.2.1");
        this.assertVersionNumber(ver, 3, 2, 1, null, false);
        ver = HBaseVersion.VersionNumber.create((String)"3.2.1-SNAPSHOT");
        this.assertVersionNumber(ver, 3, 2, 1, null, true);
        ver = HBaseVersion.VersionNumber.create((String)"3.2.1-baz");
        this.assertVersionNumber(ver, 3, 2, 1, "baz", false);
        ver = HBaseVersion.VersionNumber.create((String)"3.2.1-baz1.2.3");
        this.assertVersionNumber(ver, 3, 2, 1, "baz1.2.3", false);
        ver = HBaseVersion.VersionNumber.create((String)"3.2.1-baz1.2.3-SNAPSHOT");
        this.assertVersionNumber(ver, 3, 2, 1, "baz1.2.3", true);
        try {
            ver = HBaseVersion.VersionNumber.create((String)"abc");
            Assert.fail((String)"Invalid verison number 'abc' should have thrown a ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            ver = HBaseVersion.VersionNumber.create((String)"1.a.b");
            Assert.fail((String)"Invalid verison number '1.a.b' should have thrown a ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void assertVersionNumber(HBaseVersion.VersionNumber version, Integer expectedMajor, Integer expectedMinor, Integer expectedPatch, String expectedClassifier, boolean snapshot) {
        if (expectedMajor == null) {
            Assert.assertNull((Object)version.getMajor());
        } else {
            Assert.assertEquals((Object)expectedMajor, (Object)version.getMajor());
        }
        if (expectedMinor == null) {
            Assert.assertNull((Object)version.getMinor());
        } else {
            Assert.assertEquals((Object)expectedMinor, (Object)version.getMinor());
        }
        if (expectedPatch == null) {
            Assert.assertNull((Object)version.getPatch());
        } else {
            Assert.assertEquals((Object)expectedPatch, (Object)version.getPatch());
        }
        if (expectedClassifier == null) {
            Assert.assertNull((Object)version.getClassifier());
        } else {
            Assert.assertEquals((Object)expectedClassifier, (Object)version.getClassifier());
        }
        Assert.assertEquals((Object)snapshot, (Object)version.isSnapshot());
    }
}

