/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.snapshot;

import co.cask.tephra.ChangeId;
import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionType;
import co.cask.tephra.TxConstants;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.persist.TransactionVisibilityState;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodecProvider;
import co.cask.tephra.snapshot.SnapshotCodecV2;
import co.cask.tephra.snapshot.SnapshotCodecV3;
import co.cask.tephra.snapshot.SnapshotCodecV4;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SnapshotCodecTest {
    @ClassRule
    public static TemporaryFolder tmpDir = new TemporaryFolder();

    @Test
    public void testMinimalDeserilization() throws Exception {
        byte[] byteArray;
        long now = System.currentTimeMillis();
        long nowWritePointer = now * 1000000L;
        long tInvalid = nowWritePointer - 5L;
        long readPtr = nowWritePointer - 4L;
        long tLong = nowWritePointer - 3L;
        long tCommitted = nowWritePointer - 2L;
        long tShort = nowWritePointer - 1L;
        TreeMap inProgress = Maps.newTreeMap((SortedMap)ImmutableSortedMap.of((Comparable)Long.valueOf(tLong), (Object)new TransactionManager.InProgressTx(readPtr, TransactionManager.getTxExpirationFromWritePointer((long)tLong, (long)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT), TransactionType.LONG), (Comparable)Long.valueOf(tShort), (Object)new TransactionManager.InProgressTx(readPtr, now + 1000L, TransactionType.SHORT)));
        TransactionSnapshot snapshot = new TransactionSnapshot(now, readPtr, nowWritePointer, (Collection)Lists.newArrayList((Object[])new Long[]{tInvalid}), (NavigableMap)inProgress, (Map)ImmutableMap.of((Object)tShort, (Object)Sets.newHashSet()), (Map)ImmutableMap.of((Object)tCommitted, (Object)Sets.newHashSet()));
        Configuration conf1 = new Configuration();
        conf1.set("data.tx.snapshot.codecs", SnapshotCodecV4.class.getName());
        SnapshotCodecProvider provider1 = new SnapshotCodecProvider(conf1);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            provider1.encode((OutputStream)out, snapshot);
            byteArray = out.toByteArray();
        }
        TransactionSnapshot txSnapshot = provider1.decode((InputStream)new ByteArrayInputStream(byteArray));
        TransactionVisibilityState txVisibilityState = provider1.decodeTransactionVisibilityState((InputStream)new ByteArrayInputStream(byteArray));
        this.assertTransactionVisibilityStateEquals((TransactionVisibilityState)txSnapshot, txVisibilityState);
        byteArray[byteArray.length - 1] = 97;
        TransactionVisibilityState txVisibilityState2 = provider1.decodeTransactionVisibilityState((InputStream)new ByteArrayInputStream(byteArray));
        Assert.assertNotNull((Object)txVisibilityState2);
        Assert.assertEquals((Object)txVisibilityState, (Object)txVisibilityState2);
        Assert.assertEquals((long)readPtr, (long)txVisibilityState2.getReadPointer());
        try {
            provider1.decode((InputStream)new ByteArrayInputStream(byteArray));
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultToV3Compatibility() throws Exception {
        long now = System.currentTimeMillis();
        long nowWritePointer = now * 1000000L;
        long tInvalid = nowWritePointer - 5L;
        long readPtr = nowWritePointer - 4L;
        long tLong = nowWritePointer - 3L;
        long tCommitted = nowWritePointer - 2L;
        long tShort = nowWritePointer - 1L;
        TreeMap inProgress = Maps.newTreeMap((SortedMap)ImmutableSortedMap.of((Comparable)Long.valueOf(tLong), (Object)new TransactionManager.InProgressTx(readPtr, TransactionManager.getTxExpirationFromWritePointer((long)tLong, (long)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT), TransactionType.LONG), (Comparable)Long.valueOf(tShort), (Object)new TransactionManager.InProgressTx(readPtr, now + 1000L, TransactionType.SHORT)));
        TransactionSnapshot snapshot = new TransactionSnapshot(now, readPtr, nowWritePointer, (Collection)Lists.newArrayList((Object[])new Long[]{tInvalid}), (NavigableMap)inProgress, (Map)ImmutableMap.of((Object)tShort, (Object)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{114, 51}), new ChangeId(new byte[]{114, 52})})), (Map)ImmutableMap.of((Object)tCommitted, (Object)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{114, 49}), new ChangeId(new byte[]{114, 50})})));
        Configuration conf1 = new Configuration();
        conf1.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        SnapshotCodecProvider provider1 = new SnapshotCodecProvider(conf1);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            provider1.encode((OutputStream)out, snapshot);
        }
        TransactionSnapshot snapshot2 = provider1.decode((InputStream)new ByteArrayInputStream(out.toByteArray()));
        TransactionVisibilityState minTxSnapshot = provider1.decodeTransactionVisibilityState((InputStream)new ByteArrayInputStream(out.toByteArray()));
        this.assertTransactionVisibilityStateEquals((TransactionVisibilityState)snapshot2, minTxSnapshot);
        Assert.assertEquals((long)snapshot.getReadPointer(), (long)snapshot2.getReadPointer());
        Assert.assertEquals((long)snapshot.getWritePointer(), (long)snapshot2.getWritePointer());
        Assert.assertEquals((Object)snapshot.getInvalid(), (Object)snapshot2.getInvalid());
        Assert.assertNotEquals((Object)snapshot.getInProgress(), (Object)snapshot2.getInProgress());
        Assert.assertEquals((Object)snapshot.getCommittingChangeSets(), (Object)snapshot2.getCommittingChangeSets());
        Assert.assertEquals((Object)snapshot.getCommittedChangeSets(), (Object)snapshot2.getCommittedChangeSets());
        Map fixedInProgress = TransactionManager.txnBackwardsCompatCheck((int)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT, (long)10000L, (Map)snapshot2.getInProgress());
        Assert.assertEquals((Object)snapshot.getInProgress(), (Object)fixedInProgress);
        Assert.assertEquals((Object)snapshot, (Object)snapshot2);
    }

    @Test
    public void testDefaultToV3Migration() throws Exception {
        File testDir = tmpDir.newFolder("testDefaultToV3Migration");
        Configuration conf = new Configuration();
        conf.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        conf.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        TransactionManager txManager = (TransactionManager)injector.getInstance(TransactionManager.class);
        txManager.startAndWait();
        txManager.startLong();
        txManager.stopAndWait();
        TransactionStateStorage txStorage = (TransactionStateStorage)injector.getInstance(TransactionStateStorage.class);
        txStorage.startAndWait();
        TransactionSnapshot snapshot = txStorage.getLatestSnapshot();
        TransactionVisibilityState txVisibilityState = txStorage.getLatestTransactionVisibilityState();
        this.assertTransactionVisibilityStateEquals((TransactionVisibilityState)snapshot, txVisibilityState);
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((long)1L, (long)snapshot.getInProgress().size());
        Map.Entry entry = snapshot.getInProgress().entrySet().iterator().next();
        Assert.assertNull((Object)((TransactionManager.InProgressTx)entry.getValue()).getType());
        txStorage.stopAndWait();
        Configuration conf2 = new Configuration();
        conf2.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        conf2.setStrings("data.tx.snapshot.codecs", new String[]{DefaultSnapshotCodec.class.getName(), SnapshotCodecV3.class.getName()});
        Injector injector2 = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf2), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        TransactionManager txManager2 = (TransactionManager)injector2.getInstance(TransactionManager.class);
        txManager2.startAndWait();
        TransactionSnapshot snapshot2 = txManager2.getCurrentState();
        Assert.assertEquals((long)1L, (long)snapshot2.getInProgress().size());
        Map.Entry inProgressTx = snapshot2.getInProgress().entrySet().iterator().next();
        Assert.assertEquals((Object)TransactionType.LONG, (Object)((TransactionManager.InProgressTx)inProgressTx.getValue()).getType());
        txManager2.stopAndWait();
        TransactionStateStorage txStorage2 = (TransactionStateStorage)injector2.getInstance(TransactionStateStorage.class);
        txStorage2.startAndWait();
        TransactionSnapshot snapshot3 = txStorage2.getLatestSnapshot();
        Assert.assertEquals((Object)snapshot2.getInProgress(), (Object)snapshot3.getInProgress());
        Assert.assertEquals((Object)snapshot2, (Object)snapshot3);
        txStorage2.stopAndWait();
    }

    @Test
    public void testSnapshotCodecProviderConfiguration() throws Exception {
        Configuration conf = new Configuration(false);
        StringBuilder buf = new StringBuilder();
        for (Class c : TxConstants.Persist.DEFAULT_TX_SNAPHOT_CODEC_CLASSES) {
            if (buf.length() > 0) {
                buf.append(",\n    ");
            }
            buf.append(c.getName());
        }
        conf.set("data.tx.snapshot.codecs", buf.toString());
        SnapshotCodecProvider codecProvider = new SnapshotCodecProvider(conf);
        SnapshotCodec v1codec = codecProvider.getCodecForVersion(new DefaultSnapshotCodec().getVersion());
        Assert.assertNotNull((Object)v1codec);
        Assert.assertTrue((boolean)(v1codec instanceof DefaultSnapshotCodec));
        SnapshotCodec v2codec = codecProvider.getCodecForVersion(new SnapshotCodecV2().getVersion());
        Assert.assertNotNull((Object)v2codec);
        Assert.assertTrue((boolean)(v2codec instanceof SnapshotCodecV2));
        SnapshotCodec v3codec = codecProvider.getCodecForVersion(new SnapshotCodecV3().getVersion());
        Assert.assertNotNull((Object)v3codec);
        Assert.assertTrue((boolean)(v3codec instanceof SnapshotCodecV3));
        SnapshotCodec v4codec = codecProvider.getCodecForVersion(new SnapshotCodecV4().getVersion());
        Assert.assertNotNull((Object)v4codec);
        Assert.assertTrue((boolean)(v4codec instanceof SnapshotCodecV4));
    }

    @Test
    public void testSnapshotCodecV4() throws IOException, TransactionNotInProgressException {
        File testDir = tmpDir.newFolder("testSnapshotCodecV4");
        Configuration conf = new Configuration();
        conf.set("data.tx.snapshot.codecs", SnapshotCodecV4.class.getName());
        conf.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        TransactionManager txManager = (TransactionManager)injector.getInstance(TransactionManager.class);
        txManager.startAndWait();
        Transaction transaction = txManager.startLong();
        Transaction checkpointTx = txManager.checkpoint(transaction);
        txManager.stopAndWait();
        TransactionStateStorage txStorage = (TransactionStateStorage)injector.getInstance(TransactionStateStorage.class);
        txStorage.startAndWait();
        TransactionSnapshot snapshot = txStorage.getLatestSnapshot();
        TransactionVisibilityState txVisibilityState = txStorage.getLatestTransactionVisibilityState();
        this.assertTransactionVisibilityStateEquals((TransactionVisibilityState)snapshot, txVisibilityState);
        NavigableMap inProgress = snapshot.getInProgress();
        Assert.assertEquals((long)1L, (long)inProgress.size());
        TransactionManager.InProgressTx inProgressTx = (TransactionManager.InProgressTx)inProgress.get(transaction.getTransactionId());
        Assert.assertNotNull((Object)inProgressTx);
        Assert.assertArrayEquals((long[])checkpointTx.getCheckpointWritePointers(), (long[])inProgressTx.getCheckpointWritePointers().toLongArray());
        txStorage.stopAndWait();
        Injector injector2 = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        txManager = (TransactionManager)injector2.getInstance(TransactionManager.class);
        txManager.startAndWait();
        snapshot = txManager.getCurrentState();
        inProgress = snapshot.getInProgress();
        Assert.assertEquals((long)1L, (long)inProgress.size());
        inProgressTx = (TransactionManager.InProgressTx)inProgress.get(transaction.getTransactionId());
        Assert.assertNotNull((Object)inProgressTx);
        Assert.assertArrayEquals((long[])checkpointTx.getCheckpointWritePointers(), (long[])inProgressTx.getCheckpointWritePointers().toLongArray());
        Assert.assertTrue((boolean)txManager.canCommit(checkpointTx, Collections.emptyList()));
        Assert.assertTrue((boolean)txManager.commit(checkpointTx));
        txManager.stopAndWait();
        TransactionStateStorage txStorage2 = (TransactionStateStorage)injector2.getInstance(TransactionStateStorage.class);
        txStorage2.startAndWait();
        snapshot = txStorage2.getLatestSnapshot();
        Assert.assertTrue((boolean)snapshot.getInProgress().isEmpty());
        txStorage2.stopAndWait();
    }

    private void assertTransactionVisibilityStateEquals(TransactionVisibilityState expected, TransactionVisibilityState input) {
        Assert.assertEquals((long)expected.getTimestamp(), (long)input.getTimestamp());
        Assert.assertEquals((long)expected.getReadPointer(), (long)input.getReadPointer());
        Assert.assertEquals((long)expected.getWritePointer(), (long)input.getWritePointer());
        Assert.assertEquals((Object)expected.getInProgress(), (Object)input.getInProgress());
        Assert.assertEquals((Object)expected.getInvalid(), (Object)input.getInvalid());
    }
}

