/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionType;
import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionEditCodecs;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TransactionEditTest {
    private static final byte[] COL = new byte[]{99};

    @Test
    public void testV1SerdeCompat() throws Exception {
        TransactionEditCodecs.TransactionEditCodecV1 olderCodec = new TransactionEditCodecs.TransactionEditCodecV1();
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createStarted((long)2L, (long)0L, (long)1000L, null), (TransactionEditCodecs.TransactionEditCodec)olderCodec);
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createCommitted((long)2L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(COL)}), (long)3L, (boolean)true), (TransactionEditCodecs.TransactionEditCodec)olderCodec);
    }

    @Test
    public void testV2SerdeCompat() throws Exception {
        TransactionEditCodecs.TransactionEditCodecV2 olderCodec = new TransactionEditCodecs.TransactionEditCodecV2();
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createStarted((long)2L, (long)100L, (long)1000L, null), (TransactionEditCodecs.TransactionEditCodec)olderCodec);
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createCommitted((long)2L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(COL)}), (long)3L, (boolean)true), (TransactionEditCodecs.TransactionEditCodec)olderCodec);
    }

    private void verifyDecodingSupportsOlderVersion(TransactionEdit edit, TransactionEditCodecs.TransactionEditCodec olderCodec) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        TransactionEditCodecs.encode((TransactionEdit)edit, (DataOutput)out, (TransactionEditCodecs.TransactionEditCodec)olderCodec);
        TransactionEdit decodedEdit = new TransactionEdit();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])out.toByteArray());
        decodedEdit.readFields((DataInput)in);
        Assert.assertEquals((Object)edit, (Object)decodedEdit);
    }

    @Test
    public void testSerialization() throws Exception {
        this.assertSerializedEdit(TransactionEdit.createAborted((long)1L, (TransactionType)TransactionType.SHORT, (long[])new long[0]));
        this.assertSerializedEdit(TransactionEdit.createAborted((long)1L, (TransactionType)TransactionType.SHORT, (long[])new long[]{2L, 3L}));
        this.assertSerializedEdit(TransactionEdit.createAborted((long)1L, (TransactionType)TransactionType.LONG, (long[])new long[0]));
        this.assertSerializedEdit(TransactionEdit.createAborted((long)1L, (TransactionType)TransactionType.LONG, (long[])new long[]{2L, 3L}));
        this.assertSerializedEdit(TransactionEdit.createCheckpoint((long)2L, (long)1L));
        this.assertSerializedEdit(TransactionEdit.createCommitted((long)1L, (Set)Sets.newHashSet(), (long)2L, (boolean)false));
        this.assertSerializedEdit(TransactionEdit.createCommitted((long)1L, (Set)Sets.newHashSet(), (long)2L, (boolean)true));
        this.assertSerializedEdit(TransactionEdit.createCommitted((long)1L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{97, 98, 99})}), (long)2L, (boolean)false));
        this.assertSerializedEdit(TransactionEdit.createCommitted((long)1L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{97, 98, 99}), new ChangeId(new byte[]{100, 101, 102})}), (long)2L, (boolean)true));
        this.assertSerializedEdit(TransactionEdit.createCommitting((long)1L, (Set)Sets.newHashSet()));
        this.assertSerializedEdit(TransactionEdit.createCommitting((long)1L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{97, 98, 99})})));
        this.assertSerializedEdit(TransactionEdit.createCommitting((long)1L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{97, 98, 99}), new ChangeId(new byte[]{100, 101, 102})})));
        this.assertSerializedEdit(TransactionEdit.createInvalid((long)1L));
        this.assertSerializedEdit(TransactionEdit.createMoveWatermark((long)10L));
        this.assertSerializedEdit(TransactionEdit.createStarted((long)2L, (long)1L, (long)(System.currentTimeMillis() + 1000L), (TransactionType)TransactionType.SHORT));
        this.assertSerializedEdit(TransactionEdit.createStarted((long)2L, (long)1L, (long)(System.currentTimeMillis() + 10000L), (TransactionType)TransactionType.LONG));
        this.assertSerializedEdit(TransactionEdit.createTruncateInvalidTx((Set)Sets.newHashSet((Object[])new Long[]{new Long(1L)})));
        this.assertSerializedEdit(TransactionEdit.createTruncateInvalidTx((Set)Sets.newHashSet((Object[])new Long[]{new Long(1L), new Long(2L), new Long(3L)})));
        this.assertSerializedEdit(TransactionEdit.createTruncateInvalidTxBefore((long)System.currentTimeMillis()));
    }

    private void assertSerializedEdit(TransactionEdit originalEdit) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        originalEdit.write((DataOutput)out);
        TransactionEdit decodedEdit = new TransactionEdit();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])out.toByteArray());
        decodedEdit.readFields((DataInput)in);
        Assert.assertEquals((Object)originalEdit, (Object)decodedEdit);
    }
}

