/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.metrics.MetricsCollector;
import co.cask.tephra.metrics.TxMetricsCollector;
import co.cask.tephra.persist.AbstractTransactionStateStorage;
import co.cask.tephra.persist.AbstractTransactionStateStorageTest;
import co.cask.tephra.persist.HDFSTransactionStateStorage;
import co.cask.tephra.snapshot.SnapshotCodecProvider;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class HDFSTransactionStateStorageTest
extends AbstractTransactionStateStorageTest {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();
    private static MiniDFSCluster dfsCluster;
    private static Configuration conf;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration hConf = new Configuration();
        hConf.set("hdfs.minidfs.basedir", tmpFolder.newFolder().getAbsolutePath());
        dfsCluster = new MiniDFSCluster.Builder(hConf).numDataNodes(1).build();
        conf = new Configuration(dfsCluster.getFileSystem().getConf());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        dfsCluster.shutdown();
    }

    @Override
    protected Configuration getConfiguration(String testName) throws IOException {
        conf.unset("data.tx.hdfs.user");
        conf.set("data.tx.snapshot.dir", tmpFolder.newFolder().getAbsolutePath());
        return conf;
    }

    @Override
    protected AbstractTransactionStateStorage getStorage(Configuration conf) {
        return new HDFSTransactionStateStorage(conf, new SnapshotCodecProvider(conf), (MetricsCollector)new TxMetricsCollector());
    }
}

