/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.CommitMarkerCodec;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CommitMarkerCodecTest {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();
    private static final String LOG_FILE = "txlog";
    private static final Random RANDOM = new Random();
    private static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration hConf = new Configuration();
        hConf.set("hdfs.minidfs.basedir", TMP_FOLDER.newFolder().getAbsolutePath());
        dfsCluster = new MiniDFSCluster.Builder(hConf).numDataNodes(1).build();
        conf = new Configuration(dfsCluster.getFileSystem().getConf());
        fs = FileSystem.newInstance((URI)FileSystem.getDefaultUri((Configuration)conf), (Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        dfsCluster.shutdown();
    }

    @Test
    public void testRandomCommitMarkers() throws Exception {
        ArrayList<Integer> randomInts = new ArrayList<Integer>();
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            for (int i = 0; i < 1000; ++i) {
                int randomNum = RANDOM.nextInt(Integer.MAX_VALUE);
                CommitMarkerCodec.writeMarker((SequenceFile.Writer)writer, (int)randomNum);
                randomInts.add(randomNum);
            }
            writer.hflush();
            writer.hsync();
        }
        var4_4 = null;
        try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
             CommitMarkerCodec markerCodec = new CommitMarkerCodec();){
            Iterator i$ = randomInts.iterator();
            while (i$.hasNext()) {
                int num = (Integer)i$.next();
                Assert.assertEquals((long)num, (long)markerCodec.readMarker(reader));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIncompleteCommitMarker() throws Exception {
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            String key = "count";
            IncompleteValueBytes valueBytes = new IncompleteValueBytes();
            writer.appendRaw(key.getBytes(), 0, key.length(), (SequenceFile.ValueBytes)valueBytes);
            writer.hflush();
            writer.hsync();
        }
        var3_3 = null;
        try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
             CommitMarkerCodec markerCodec = new CommitMarkerCodec();){
            try {
                markerCodec.readMarker(reader);
                Assert.fail((String)"Expected EOF Exception to be thrown");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIncorrectCommitMarker() throws Exception {
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            String invalidKey = "IncorrectKey";
            CommitMarkerCodec.CommitEntriesCount valueBytes = new CommitMarkerCodec.CommitEntriesCount(100);
            writer.appendRaw(invalidKey.getBytes(), 0, invalidKey.length(), (SequenceFile.ValueBytes)valueBytes);
            writer.hflush();
            writer.hsync();
        }
        var3_3 = null;
        try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
             CommitMarkerCodec markerCodec = new CommitMarkerCodec();){
            try {
                markerCodec.readMarker(reader);
                Assert.fail((String)"Expected an IOException to be thrown");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private static class IncompleteValueBytes
    implements SequenceFile.ValueBytes {
        private IncompleteValueBytes() {
        }

        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
        }

        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("Not possible");
        }

        public int getSize() {
            return 4;
        }
    }
}

