/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.ThriftTransactionSystemTest;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.distributed.TransactionService;
import co.cask.tephra.persist.InMemoryTransactionStateStorage;
import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLog;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionClientModule;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.runtime.ZKModule;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTransactionServerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftTransactionSystemTest.class);
    private static InMemoryZKServer zkServer;
    private static ZKClientService zkClientService;
    private static TransactionService txService;
    private static TransactionStateStorage storage;
    static Injector injector;
    private static final int NUM_CLIENTS = 17;
    private static final CountDownLatch STORAGE_WAIT_LATCH;
    private static final CountDownLatch CLIENTS_DONE_LATCH;
    @ClassRule
    public static TemporaryFolder tmpFolder;

    @BeforeClass
    public static void start() throws Exception {
        zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
        Configuration conf = new Configuration();
        conf.setBoolean("tx.persist", false);
        conf.set("data.tx.zookeeper.quorum", zkServer.getConnectionStr());
        conf.set("data.tx.client.retry.strategy", "n-times");
        conf.setInt("data.tx.client.retry.attempts", 1);
        conf.setInt("data.tx.client.count", 17);
        conf.setLong("data.tx.client.timeout", TimeUnit.HOURS.toMillis(1L));
        conf.setInt("data.tx.server.io.threads", 2);
        conf.setInt("data.tx.server.threads", 4);
        injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), Modules.override((Module[])new Module[]{new TransactionModules().getDistributedModules()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TransactionStateStorage.class).to(SlowTransactionStorage.class).in(Scopes.SINGLETON);
            }
        }}), new TransactionClientModule()});
        zkClientService = (ZKClientService)injector.getInstance(ZKClientService.class);
        zkClientService.startAndWait();
        txService = (TransactionService)injector.getInstance(TransactionService.class);
        storage = (TransactionStateStorage)injector.getInstance(TransactionStateStorage.class);
        try {
            LOG.info("Starting transaction service");
            txService.startAndWait();
        }
        catch (Exception e) {
            LOG.error("Failed to start service: ", (Throwable)e);
        }
    }

    @Before
    public void reset() throws Exception {
        this.getClient().resetState();
    }

    @AfterClass
    public static void stop() throws Exception {
        txService.stopAndWait();
        storage.stopAndWait();
        zkClientService.stopAndWait();
        zkServer.stopAndWait();
    }

    public TransactionSystemClient getClient() throws Exception {
        return (TransactionSystemClient)injector.getInstance(TransactionSystemClient.class);
    }

    @Test
    public void testThriftServerStop() throws Exception {
        int nThreads = 17;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransactionSystemClient txClient = ThriftTransactionServerTest.this.getClient();
                        CLIENTS_DONE_LATCH.countDown();
                        txClient.startShort();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        CLIENTS_DONE_LATCH.await();
        TimeUnit.SECONDS.sleep(1L);
        this.expireZkSession(zkClientService);
        this.waitForThriftTermination();
        zkClientService.stopAndWait();
        STORAGE_WAIT_LATCH.countDown();
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertEquals((Object)Service.State.TERMINATED, (Object)txService.thriftRPCServerState());
    }

    private void expireZkSession(ZKClientService zkClientService) throws Exception {
        ZooKeeper zooKeeper = (ZooKeeper)zkClientService.getZooKeeperSupplier().get();
        final SettableFuture connectFuture = SettableFuture.create();
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connectFuture.set(null);
                }
            }
        };
        ZooKeeper dupZookeeper = new ZooKeeper(zkClientService.getConnectString(), zooKeeper.getSessionTimeout(), watcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        connectFuture.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Failed to re-create current session", (Object)dupZookeeper.getState(), (Object)ZooKeeper.States.CONNECTED);
        dupZookeeper.close();
    }

    private void waitForThriftTermination() throws InterruptedException {
        int count = 0;
        while (txService.thriftRPCServerState() != Service.State.TERMINATED && count++ < 200) {
            TimeUnit.MILLISECONDS.sleep(50L);
        }
    }

    static {
        STORAGE_WAIT_LATCH = new CountDownLatch(1);
        CLIENTS_DONE_LATCH = new CountDownLatch(17);
        tmpFolder = new TemporaryFolder();
    }

    private static class SlowTransactionLog
    extends InMemoryTransactionStateStorage.InMemoryTransactionLog {
        public SlowTransactionLog(long timestamp) {
            super(timestamp);
        }

        @Override
        public void append(TransactionEdit edit) throws IOException {
            try {
                STORAGE_WAIT_LATCH.await();
            }
            catch (InterruptedException e) {
                LOG.error("Got exception: ", (Throwable)e);
            }
            super.append(edit);
        }

        @Override
        public void append(List<TransactionEdit> edits) throws IOException {
            try {
                STORAGE_WAIT_LATCH.await();
            }
            catch (InterruptedException e) {
                LOG.error("Got exception: ", (Throwable)e);
            }
            super.append(edits);
        }
    }

    private static class SlowTransactionStorage
    extends InMemoryTransactionStateStorage {
        private SlowTransactionStorage() {
        }

        @Override
        public TransactionLog createLog(long timestamp) throws IOException {
            return new SlowTransactionLog(timestamp);
        }
    }
}

