/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TransactionTest {
    private final long txId = 200L;
    private final long readPointer = 100L;
    private final Set<Long> priorCommitted = ImmutableSet.of((Object)80L, (Object)99L, (Object)100L);
    private final Set<Long> postCommitted = ImmutableSet.of((Object)150L, (Object)180L, (Object)210L);
    private final Set<Long> priorInvalids = ImmutableSet.of((Object)90L, (Object)110L, (Object)190L);
    private final Set<Long> postInvalids = ImmutableSet.of((Object)201L, (Object)221L, (Object)231L);
    private final Set<Long> priorInProgress = ImmutableSet.of((Object)95L, (Object)120L, (Object)150L);
    private final Set<Long> postInProgress = ImmutableSet.of((Object)205L, (Object)215L, (Object)300L);

    @Test
    public void testSnapshotVisibility() throws Exception {
        Transaction.VisibilityLevel visibilityLevel = Transaction.VisibilityLevel.SNAPSHOT;
        ImmutableSet checkPointers = ImmutableSet.of((Object)220L, (Object)250L);
        Transaction tx = new Transaction(100L, 200L, 250L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        ImmutableSet visibleCurrent = ImmutableSet.of((Object)200L, (Object)220L, (Object)250L);
        ImmutableSet notVisibleCurrent = ImmutableSet.of();
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
        checkPointers = ImmutableSet.of();
        tx = new Transaction(100L, 200L, 200L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        visibleCurrent = ImmutableSet.of((Object)200L);
        notVisibleCurrent = ImmutableSet.of();
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
    }

    @Test
    public void testSnapshotExcludeVisibility() throws Exception {
        Transaction.VisibilityLevel visibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
        ImmutableSet checkPointers = ImmutableSet.of((Object)220L, (Object)250L);
        Transaction tx = new Transaction(100L, 200L, 250L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        ImmutableSet visibleCurrent = ImmutableSet.of((Object)200L, (Object)220L);
        ImmutableSet notVisibleCurrent = ImmutableSet.of((Object)250L);
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
        checkPointers = ImmutableSet.of();
        tx = new Transaction(100L, 200L, 200L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        visibleCurrent = ImmutableSet.of();
        notVisibleCurrent = ImmutableSet.of((Object)200L);
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
    }

    @Test
    public void testSnapshotAllVisibility() throws Exception {
        Transaction.VisibilityLevel visibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_ALL;
        ImmutableSet checkPointers = ImmutableSet.of((Object)220L, (Object)250L);
        Transaction tx = new Transaction(100L, 200L, 250L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        ImmutableSet visibleCurrent = ImmutableSet.of((Object)200L, (Object)220L, (Object)250L);
        ImmutableSet notVisibleCurrent = ImmutableSet.of();
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
        checkPointers = ImmutableSet.of();
        tx = new Transaction(100L, 200L, 200L, this.toSortedArray(this.priorInvalids), this.toSortedArray(this.priorInProgress), 95L, TransactionType.SHORT, this.toSortedArray((Set<Long>)checkPointers), visibilityLevel);
        visibleCurrent = ImmutableSet.of((Object)200L);
        notVisibleCurrent = ImmutableSet.of();
        this.assertVisibility(this.priorCommitted, this.postCommitted, this.priorInvalids, this.postInvalids, this.priorInProgress, this.postInProgress, (Set<Long>)visibleCurrent, (Set<Long>)notVisibleCurrent, tx);
    }

    private void assertVisibility(Set<Long> priorCommitted, Set<Long> postCommitted, Set<Long> priorInvalids, Set<Long> postInvalids, Set<Long> priorInProgress, Set<Long> postInProgress, Set<Long> visibleCurrent, Set<Long> notVisibleCurrent, Transaction tx) {
        for (long t : visibleCurrent) {
            Assert.assertTrue((String)("Assertion error for version = " + t), (boolean)tx.isVisible(t));
        }
        for (long t : notVisibleCurrent) {
            Assert.assertFalse((String)("Assertion error for version = " + t), (boolean)tx.isVisible(t));
        }
        for (long t : priorCommitted) {
            Assert.assertTrue((String)("Assertion error for version = " + t), (boolean)tx.isVisible(t));
        }
        for (long t : postCommitted) {
            Assert.assertFalse((String)("Assertion error for version = " + t), (boolean)tx.isVisible(t));
        }
        for (long t : Iterables.concat(priorInvalids, postInvalids, priorInProgress, postInProgress)) {
            Assert.assertFalse((String)("Assertion error for version = " + t), (boolean)tx.isVisible(t));
        }
    }

    private long[] toSortedArray(Set<Long> set) {
        long[] array = Longs.toArray(set);
        Arrays.sort(array);
        return array;
    }
}

