/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.InvalidTruncateTimeException;
import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.TransactionSystemTest;
import co.cask.tephra.inmemory.InMemoryTxSystemClient;
import co.cask.tephra.metrics.MetricsCollector;
import co.cask.tephra.metrics.TxMetricsCollector;
import co.cask.tephra.persist.InMemoryTransactionStateStorage;
import co.cask.tephra.persist.TransactionStateStorage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionManagerTest
extends TransactionSystemTest {
    static Configuration conf = new Configuration();
    TransactionManager txManager = null;
    TransactionStateStorage txStateStorage = null;

    @Override
    protected TransactionSystemClient getClient() {
        return new InMemoryTxSystemClient(this.txManager);
    }

    @Override
    protected TransactionStateStorage getStateStorage() {
        return this.txStateStorage;
    }

    @Before
    public void before() {
        conf.setInt("data.tx.cleanup.interval", 0);
        this.txStateStorage = new InMemoryTransactionStateStorage();
        this.txManager = new TransactionManager(conf, this.txStateStorage, (MetricsCollector)new TxMetricsCollector());
        this.txManager.startAndWait();
    }

    @After
    public void after() {
        this.txManager.stopAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionCleanup() throws Exception {
        conf.setInt("data.tx.cleanup.interval", 3);
        conf.setInt("data.tx.timeout", 2);
        TransactionManager txm = new TransactionManager(conf, (TransactionStateStorage)new InMemoryTransactionStateStorage(), (MetricsCollector)new TxMetricsCollector());
        txm.startAndWait();
        try {
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            Transaction tx1 = txm.startShort();
            Transaction tx2 = txm.startLong();
            Transaction tx3 = txm.startLong();
            for (int i = 0; i < 10; ++i) {
                Transaction tx = txm.startShort();
                Assert.assertTrue((boolean)txm.canCommit(tx, Collections.singleton(new byte[]{(byte)i})));
                Assert.assertTrue((boolean)txm.commit(tx));
            }
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)10L, (long)txm.getCommittedSize());
            TimeUnit.SECONDS.sleep(5L);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
            Transaction txx = txm.startShort();
            Assert.assertFalse((boolean)txx.isVisible(tx1.getTransactionId()));
            Assert.assertFalse((boolean)txx.isVisible(tx2.getTransactionId()));
            Assert.assertFalse((boolean)txx.isVisible(tx3.getTransactionId()));
            Assert.assertTrue((boolean)txm.canCommit(txx, Collections.singleton(new byte[]{10})));
            Assert.assertTrue((boolean)txm.commit(txx));
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            try {
                txm.canCommit(tx1, Collections.singleton(new byte[]{17}));
                Assert.fail();
            }
            catch (TransactionNotInProgressException tx) {
                // empty catch block
            }
            txm.abort(tx1);
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            for (int i = 0; i < 10; ++i) {
                Transaction tx = txm.startShort();
                Assert.assertTrue((boolean)txm.canCommit(tx, Collections.singleton(new byte[]{(byte)i})));
                Assert.assertTrue((boolean)txm.commit(tx));
            }
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            Assert.assertTrue((boolean)txm.commit(tx2));
            txm.abort(tx3);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)tx3.getTransactionId(), (long)((Long)txm.getCurrentState().getInvalid().iterator().next()));
            Assert.assertEquals((long)1L, (long)txm.getExcludedListSize());
        }
        finally {
            txm.stopAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongTransactionCleanup() throws Exception {
        conf.setInt("data.tx.cleanup.interval", 3);
        conf.setInt("data.tx.long.timeout", 2);
        TransactionManager txm = new TransactionManager(conf, (TransactionStateStorage)new InMemoryTransactionStateStorage(), (MetricsCollector)new TxMetricsCollector());
        txm.startAndWait();
        try {
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            Transaction tx1 = txm.startLong();
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            TimeUnit.SECONDS.sleep(5L);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            try {
                txm.canCommit(tx1, Collections.singleton(new byte[]{17}));
                Assert.fail();
            }
            catch (TransactionNotInProgressException transactionNotInProgressException) {
                // empty catch block
            }
            txm.abort(tx1);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
        }
        finally {
            txm.stopAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateInvalid() throws Exception {
        InMemoryTransactionStateStorage storage = new InMemoryTransactionStateStorage();
        Configuration testConf = new Configuration(conf);
        testConf.setLong("data.tx.snapshot.interval", -1L);
        TransactionManager txm1 = new TransactionManager(testConf, (TransactionStateStorage)storage, (MetricsCollector)new TxMetricsCollector());
        txm1.startAndWait();
        TransactionManager txm2 = null;
        try {
            Assert.assertEquals((long)0L, (long)txm1.getInvalidSize());
            Transaction tx1 = txm1.startLong();
            Transaction tx2 = txm1.startShort();
            Transaction tx3 = txm1.startLong();
            Transaction tx4 = txm1.startShort();
            Transaction tx5 = txm1.startLong();
            Transaction tx6 = txm1.startShort();
            txm1.invalidate(tx1.getTransactionId());
            txm1.invalidate(tx2.getTransactionId());
            txm1.invalidate(tx5.getTransactionId());
            txm1.invalidate(tx6.getTransactionId());
            Assert.assertEquals((Object)ImmutableList.of((Object)tx1.getTransactionId(), (Object)tx2.getTransactionId(), (Object)tx5.getTransactionId(), (Object)tx6.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            Assert.assertTrue((boolean)txm1.truncateInvalidTx((Set)ImmutableSet.of((Object)tx1.getTransactionId(), (Object)tx6.getTransactionId())));
            Assert.assertEquals((Object)ImmutableList.of((Object)tx2.getTransactionId(), (Object)tx5.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm1.getCurrentState().getInProgress().keySet());
            Assert.assertFalse((boolean)txm1.truncateInvalidTx((Set)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId())));
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm1.getCurrentState().getInProgress().keySet());
            Assert.assertEquals((Object)ImmutableList.of((Object)tx2.getTransactionId(), (Object)tx5.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            txm2 = new TransactionManager(testConf, (TransactionStateStorage)storage, (MetricsCollector)new TxMetricsCollector());
            txm2.startAndWait();
            Assert.assertEquals((Object)ImmutableList.of((Object)tx2.getTransactionId(), (Object)tx5.getTransactionId()), (Object)txm2.getCurrentState().getInvalid());
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm2.getCurrentState().getInProgress().keySet());
        }
        finally {
            txm1.stopAndWait();
            if (txm2 != null) {
                txm2.stopAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateInvalidBeforeTime() throws Exception {
        InMemoryTransactionStateStorage storage = new InMemoryTransactionStateStorage();
        Configuration testConf = new Configuration(conf);
        testConf.setLong("data.tx.snapshot.interval", -1L);
        TransactionManager txm1 = new TransactionManager(testConf, (TransactionStateStorage)storage, (MetricsCollector)new TxMetricsCollector());
        txm1.startAndWait();
        TransactionManager txm2 = null;
        try {
            Assert.assertEquals((long)0L, (long)txm1.getInvalidSize());
            Transaction tx1 = txm1.startLong();
            Transaction tx2 = txm1.startShort();
            TimeUnit.MILLISECONDS.sleep(1L);
            long timeBeforeTx3 = System.currentTimeMillis();
            Transaction tx3 = txm1.startLong();
            Transaction tx4 = txm1.startShort();
            TimeUnit.MILLISECONDS.sleep(1L);
            long timeBeforeTx5 = System.currentTimeMillis();
            Transaction tx5 = txm1.startLong();
            Transaction tx6 = txm1.startShort();
            txm1.invalidate(tx1.getTransactionId());
            txm1.invalidate(tx2.getTransactionId());
            txm1.invalidate(tx5.getTransactionId());
            txm1.invalidate(tx6.getTransactionId());
            Assert.assertEquals((Object)ImmutableList.of((Object)tx1.getTransactionId(), (Object)tx2.getTransactionId(), (Object)tx5.getTransactionId(), (Object)tx6.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            Assert.assertTrue((boolean)txm1.truncateInvalidTxBefore(timeBeforeTx3));
            Assert.assertEquals((Object)ImmutableList.of((Object)tx5.getTransactionId(), (Object)tx6.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm1.getCurrentState().getInProgress().keySet());
            try {
                txm1.truncateInvalidTxBefore(timeBeforeTx5);
                Assert.fail((String)"Expected InvalidTruncateTimeException exception");
            }
            catch (InvalidTruncateTimeException invalidTruncateTimeException) {
                // empty catch block
            }
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm1.getCurrentState().getInProgress().keySet());
            Assert.assertEquals((Object)ImmutableList.of((Object)tx5.getTransactionId(), (Object)tx6.getTransactionId()), (Object)txm1.getCurrentState().getInvalid());
            txm2 = new TransactionManager(testConf, (TransactionStateStorage)storage, (MetricsCollector)new TxMetricsCollector());
            txm2.startAndWait();
            Assert.assertEquals((Object)ImmutableList.of((Object)tx5.getTransactionId(), (Object)tx6.getTransactionId()), (Object)txm2.getCurrentState().getInvalid());
            Assert.assertEquals((Object)ImmutableSet.of((Object)tx3.getTransactionId(), (Object)tx4.getTransactionId()), txm2.getCurrentState().getInProgress().keySet());
        }
        finally {
            txm1.stopAndWait();
            if (txm2 != null) {
                txm2.stopAndWait();
            }
        }
    }
}

